﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;
using System.ServiceModel;

namespace BMS.Utils
{
    public class PoolProxy<T> where T : class, ICommunicationObject, IDisposable
    {
        List<T> items;        
        int maxCount = int.Parse(ConfigurationManager.AppSettings["ProxyPoolMaxCount"]);

        public PoolProxy()
        {
            Initialize();
        }

        public void Initialize()
        {
            items = new List<T>(maxCount);
        }

        public int Count
        {
            get { return items != null ? items.Count : 0; }
        }

        public T Take()
        {
            if (items == null) Initialize();
            if (items.Count > 0)
            {
                T item = items.Last();
                items.Remove(item);
                return item;
            }
            else            
                return null;            
        }

        public bool Return(T item)
        {
            if (items == null) Initialize();
            if (items.Count < maxCount)
            {
                items.Add(item);                
                return true;
            }
            else
                return false;
        }

        public void Clear()
        {
            if (items != null && items.Count > 0)
            {
                foreach (T item in items)
                {
                    try
                    {
                        item.Close();
                    }
                    catch
                    {
                        item.Abort();
                    }
                    item.Dispose();
                }
                items.Clear();
                items = null;
            }
        }
    }
}
