﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.ServicesWrapper.Security
{
    /// <summary>
    /// The user roles.
    /// </summary>
    public class UserRoles
    {
        /// <summary>
        /// Gets or sets the name of the user.
        /// </summary>
        /// <value>
        /// The name of the user.
        /// </value>
        public string UserName { get; set; }
        /// <summary>
        /// Gets or sets the user id.
        /// </summary>
        /// <value>
        /// The user id.
        /// </value>
        public string UserId { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is administrator.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is administrator; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdministrator { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is EMS user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is EMS user; otherwise, <c>false</c>.
        /// </value>
        public bool IsEMSUser { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is guest user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is guest user; otherwise, <c>false</c>.
        /// </value>
        public bool IsGuestUser { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is national user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is national user; otherwise, <c>false</c>.
        /// </value>
        public bool IsNationalUser { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is regional user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is regional user; otherwise, <c>false</c>.
        /// </value>
        public bool IsRegionalUser { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is site user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is site user; otherwise, <c>false</c>.
        /// </value>
        public bool IsSiteUser { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is support user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is support user; otherwise, <c>false</c>.
        /// </value>
        public bool IsSupportUser { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is visn user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is visn user; otherwise, <c>false</c>.
        /// </value>
        public bool IsVisnUser { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is audit log user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is audit log user; otherwise, <c>false</c>.
        /// </value>
        public bool IsAuditLogUser { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is EMS supervisor user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is EMS supervisor user; otherwise, <c>false</c>.
        /// </value>
        public bool IsEMSSupervisorUser { get; set; }

    }
}
