using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using InfoWorld.EVS.CTSMAPI;
using BMS.Utils;

namespace BMS.ServicesWrapper.Proxy.EVS.Edit
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ServiceModel.ServiceContractAttribute(Namespace = "urn://InfoWorld.org/CTSMessageEdit", ConfigurationName = "InfoWorld.EVS.CTSEdit.IMessageEdit")]
    public interface IMessageEdit
    {

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/DeleteValueSet", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/DeleteValueSetResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteValueSet(ValueSetDescriptor[] valueSetID);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/DeleteValueSet_CodeReference", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/DeleteValueSet_CodeReferenceResp" +
            "onse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteValueSet_CodeReference(ValueSetDescriptor valueSet, string[] codes);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/DeleteValueSet_ValueSetReference" +
            "", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/DeleteValueSet_ValueSetReference" +
            "Response")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteValueSet_ValueSetReference(ValueSetDescriptor valueSet, ValueSetConstructor[] valueSetReference);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/DeleteVocabularyDomain_ValueSet", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/DeleteVocabularyDomain_ValueSetR" +
            "esponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteVocabularyDomain_ValueSet(ValueSetDescriptor[] valueSet, string[] vocabularyDomain, string[] context);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/InsertValueSet", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/InsertValueSetResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void InsertValueSet(ValueSetDescriptor[] valueSet, string[] basedOnCodeSystem_ID, bool[] allCodes, string[] definingExpression, string[] description);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/InsertValueSet_CodeReferece", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/InsertValueSet_CodeRefereceRespo" +
            "nse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void InsertValueSet_CodeReferece(ValueSetDescriptor valueSet, ValueSetCodeReference[] codes, bool[] isHeadCode);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/InsertValueSet_ValueSetReferece", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/InsertValueSet_ValueSetRefereceR" +
            "esponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void InsertValueSet_ValueSetReferece(ValueSetDescriptor valueSet, ValueSetConstructor[] valueSetReference);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/InsertVocabularyDomain_ValueSet", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/InsertVocabularyDomain_ValueSetR" +
            "esponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void InsertVocabularyDomain_ValueSet(ValueSetDescriptor[] valueSet, string[] vocabularyDomain, string[] context);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/UpdateValueSet", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/UpdateValueSetResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void UpdateValueSet(ValueSetDescriptor[] valueSet, string[] definingExpression, string[] description);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/UpdateValueSet_CodeReference", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/UpdateValueSet_CodeReferenceResp" +
            "onse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void UpdateValueSet_CodeReference(ValueSetDescriptor valueSet, ValueSetCodeReference[] codes, bool[] isHeadCode);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/UpdateValueSet_ValueSetReference" +
            "", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/UpdateValueSet_ValueSetReference" +
            "Response")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void UpdateValueSet_ValueSetReference(ValueSetDescriptor valueSet, ValueSetConstructor[] valueSetReference);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/UpdateVocabularyDomain_ValueSet", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/UpdateVocabularyDomain_ValueSetR" +
            "esponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void UpdateVocabularyDomain_ValueSet(ValueSetDescriptor[] valueSet, string[] vocabularyDomain, string[] context, ValueSetDescriptor[] valueSetOld, string[] contextOld);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/ReExpandValueSet", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditValueSet/ReExpandValueSetResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void ReExpandValueSet(string valueSetId);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditVocabularyDomain/Insert", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditVocabularyDomain/InsertResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void Insert(string[] vocabularyDomain, string[] description, string[] restrictsDomain);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditVocabularyDomain/Udate", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditVocabularyDomain/UdateResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void Udate(string[] vocabularyDomain, string[] descriptionNew, string[] restrictsDomainNew);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSMessageEdit/IEditVocabularyDomain/Delete", ReplyAction = "urn://InfoWorld.org/CTSMessageEdit/IEditVocabularyDomain/DeleteResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSEdit.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InfoWorld.EVS.CTSEdit.UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void Delete(string[] vocabularyDomain);
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface IMessageEditChannel : IMessageEdit, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class MessageEditClient : System.ServiceModel.ClientBase<IMessageEdit>, IMessageEdit, System.IDisposable
    {
        #region ProxyTool Generated Code

        private MessageEditClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;

        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new MessageEditClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new MessageEditClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new MessageEditClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new MessageEditClient(_endpointConfigurationName);
                else
                    _instance = new MessageEditClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<IMessageEdit>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<IMessageEdit>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<IMessageEdit>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<IMessageEdit>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public MessageEditClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public MessageEditClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public MessageEditClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public MessageEditClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public MessageEditClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteValueSet(ValueSetDescriptor[] valueSetID)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteValueSet(valueSetID);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteValueSet(valueSetID);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteValueSet_CodeReference(ValueSetDescriptor valueSet, string[] codes)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteValueSet_CodeReference(valueSet, codes);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteValueSet_CodeReference(valueSet, codes);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteValueSet_ValueSetReference(ValueSetDescriptor valueSet, ValueSetConstructor[] valueSetReference)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteValueSet_ValueSetReference(valueSet, valueSetReference);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteValueSet_ValueSetReference(valueSet, valueSetReference);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteVocabularyDomain_ValueSet(ValueSetDescriptor[] valueSet, string[] vocabularyDomain, string[] context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteVocabularyDomain_ValueSet(valueSet, vocabularyDomain, context);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteVocabularyDomain_ValueSet(valueSet, vocabularyDomain, context);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertValueSet(ValueSetDescriptor[] valueSet, string[] basedOnCodeSystem_ID, bool[] allCodes, string[] definingExpression, string[] description)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertValueSet(valueSet, basedOnCodeSystem_ID, allCodes, definingExpression, description);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertValueSet(valueSet, basedOnCodeSystem_ID, allCodes, definingExpression, description);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertValueSet_CodeReferece(ValueSetDescriptor valueSet, ValueSetCodeReference[] codes, bool[] isHeadCode)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertValueSet_CodeReferece(valueSet, codes, isHeadCode);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertValueSet_CodeReferece(valueSet, codes, isHeadCode);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertValueSet_ValueSetReferece(ValueSetDescriptor valueSet, ValueSetConstructor[] valueSetReference)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertValueSet_ValueSetReferece(valueSet, valueSetReference);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertValueSet_ValueSetReferece(valueSet, valueSetReference);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertVocabularyDomain_ValueSet(ValueSetDescriptor[] valueSet, string[] vocabularyDomain, string[] context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertVocabularyDomain_ValueSet(valueSet, vocabularyDomain, context);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertVocabularyDomain_ValueSet(valueSet, vocabularyDomain, context);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateValueSet(ValueSetDescriptor[] valueSet, string[] definingExpression, string[] description)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateValueSet(valueSet, definingExpression, description);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateValueSet(valueSet, definingExpression, description);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateValueSet_CodeReference(ValueSetDescriptor valueSet, ValueSetCodeReference[] codes, bool[] isHeadCode)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateValueSet_CodeReference(valueSet, codes, isHeadCode);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateValueSet_CodeReference(valueSet, codes, isHeadCode);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateValueSet_ValueSetReference(ValueSetDescriptor valueSet, ValueSetConstructor[] valueSetReference)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateValueSet_ValueSetReference(valueSet, valueSetReference);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateValueSet_ValueSetReference(valueSet, valueSetReference);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateVocabularyDomain_ValueSet(ValueSetDescriptor[] valueSet, string[] vocabularyDomain, string[] context, ValueSetDescriptor[] valueSetOld, string[] contextOld)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateVocabularyDomain_ValueSet(valueSet, vocabularyDomain, context, valueSetOld, contextOld);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateVocabularyDomain_ValueSet(valueSet, vocabularyDomain, context, valueSetOld, contextOld);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void ReExpandValueSet(string valueSetId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.ReExpandValueSet(valueSetId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.ReExpandValueSet(valueSetId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void Insert(string[] vocabularyDomain, string[] description, string[] restrictsDomain)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.Insert(vocabularyDomain, description, restrictsDomain);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.Insert(vocabularyDomain, description, restrictsDomain);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void Udate(string[] vocabularyDomain, string[] descriptionNew, string[] restrictsDomainNew)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.Udate(vocabularyDomain, descriptionNew, restrictsDomainNew);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.Udate(vocabularyDomain, descriptionNew, restrictsDomainNew);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void Delete(string[] vocabularyDomain)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.Delete(vocabularyDomain);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.Delete(vocabularyDomain);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<MessageEditClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
