using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;

namespace BMS.ServicesWrapper.Proxy.EVS.MAPI
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ServiceModel.ServiceContractAttribute(Namespace = "urn://hl7.org/CTSMAPI", ConfigurationName = "InfoWorld.EVS.CTSMAPI.BrowserOperations")]
    public interface BrowserOperations
    {

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/getSupportedMatchAlgorithms", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/getSupportedMatchAlgorithmsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getSupportedMatchAlgorithmsReturn")]
        InfoWorld.HL7.ITS.ST[] getSupportedMatchAlgorithms();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/getSupportedAttributes", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/getSupportedAttributesResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getSupportedAttributesReturn")]
        InfoWorld.EVS.CTSMAPI.RIMCodedAttribute[] getSupportedAttributes(InfoWorld.HL7.ITS.ST in0, InfoWorld.HL7.ITS.ST in1, int in2, int in3);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/getSupportedVocabularyDomains", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/getSupportedVocabularyDomainsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getSupportedVocabularyDomainsReturn")]
        InfoWorld.HL7.ITS.ST[] getSupportedVocabularyDomains(InfoWorld.HL7.ITS.ST in0, InfoWorld.HL7.ITS.ST in1, int in2, int in3);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/getSupportedValueSets", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/getSupportedValueSetsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getSupportedValueSetsReturn")]
        InfoWorld.EVS.CTSMAPI.ValueSetDescriptor[] getSupportedValueSets(InfoWorld.HL7.ITS.ST in0, InfoWorld.HL7.ITS.ST in1, int in2, int in3);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/getSupportedCodeSystems", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/getSupportedCodeSystemsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getSupportedCodeSystemsReturn")]
        InfoWorld.EVS.CTSMAPI.CodeSystemDescriptor[] getSupportedCodeSystems(InfoWorld.HL7.ITS.ST in0, InfoWorld.HL7.ITS.ST in1, int in2, int in3);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupVocabularyDomain", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupVocabularyDomainResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupVocabularyDomainReturn")]
        InfoWorld.EVS.CTSMAPI.VocabularyDomainDescription lookupVocabularyDomain(InfoWorld.HL7.ITS.ST in0);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupCodeSystem", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupCodeSystemResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.CodeSystemNameIdMismatch), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CodeSystemNameIdMismatch")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupCodeSystemReturn")]
        InfoWorld.EVS.CTSMAPI.CodeSystemInfo lookupCodeSystem(InfoWorld.EVS.CTSMAPI.UID in0, InfoWorld.HL7.ITS.ST in1);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupValueSetForDomain", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupValueSetForDomainResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownApplicationContextCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownApplicationContextCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.NoApplicableValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupValueSetForDomainReturn")]
        InfoWorld.EVS.CTSMAPI.ValueSetDescriptor lookupValueSetForDomain(InfoWorld.HL7.ITS.ST in0, InfoWorld.HL7.ITS.ST in1);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/isCodeInValueSet", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/isCodeInValueSetResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.ValueSetNameIdMismatch), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "ValueSetNameIdMismatch")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownConceptCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownConceptCode")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "isCodeInValueSetReturn")]
        InfoWorld.HL7.ITS.BL isCodeInValueSet(InfoWorld.EVS.CTSMAPI.UID in0, InfoWorld.HL7.ITS.ST in1, InfoWorld.HL7.ITS.BL in2, InfoWorld.EVS.CTSMAPI.ConceptId in3);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/getServiceName", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/getServiceNameResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceNameReturn")]
        InfoWorld.HL7.ITS.ST getServiceName();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/getServiceVersion", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/getServiceVersionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceVersionReturn")]
        InfoWorld.HL7.ITS.ST getServiceVersion();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/getServiceDescription", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/getServiceDescriptionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceDescriptionReturn")]
        InfoWorld.HL7.ITS.ST getServiceDescription();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/getHL7ReleaseVersion", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/getHL7ReleaseVersionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getHL7ReleaseVersionReturn")]
        InfoWorld.HL7.ITS.ST getHL7ReleaseVersion();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/getCTSVersion", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/getCTSVersionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.IVXB_INT))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SXCM_INT))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.IVL_INT))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getCTSVersionReturn")]
        InfoWorld.EVS.CTSMAPI.CTSVersionId getCTSVersion();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByDesignationInValueSet" +
            "", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByDesignationInValueSet" +
            "Response")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupConceptCodesByDesignationReturn")]
        InfoWorld.HL7.ITS.CD[] lookupConceptCodesByDesignationInValueSet(string valueSet_id, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByDesignationInValueSet" +
            "WithProperties", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByDesignationInValueSet" +
            "WithPropertiesResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupConceptCodesByDesignationReturn")]
        InfoWorld.EVS.CTSMAPI.CDWithProperties[] lookupConceptCodesByDesignationInValueSetWithProperties(string valueSet_id, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit, string[] properties);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByDesignationInDomain", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByDesignationInDomainRe" +
            "sponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.NoApplicableValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupConceptCodesByDesignationReturn")]
        InfoWorld.HL7.ITS.CD[] lookupConceptCodesByDesignationInDomain(string vocabularyDomain_Name, string context, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByCodeInValueSet", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByCodeInValueSetRespons" +
            "e")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupConceptCodesByCodeReturn")]
        InfoWorld.HL7.ITS.CD[] lookupConceptCodesByCodeInValueSet(string valueSet_id, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByCodeInValueSetWithPaging", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByCodeInValueSetWithPagingResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupConceptCodesByCodeWithPagingReturn")]
        InfoWorld.HL7.ITS.CD[] lookupConceptCodesByCodeInValueSetWithPaging(string valueSet_id, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit, int minPk, out int lastPkSelected);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByCodeInDomain", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByCodeInDomainResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.NoApplicableValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupConceptCodesByDesignationReturn")]
        InfoWorld.HL7.ITS.CD[] lookupConceptCodesByCodeInDomain(string vocabularyDomain_Name, string context, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByCodeInValueSetWithPro" +
            "perties", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByCodeInValueSetWithPro" +
            "pertiesResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupConceptCodesByCodeReturn")]
        InfoWorld.EVS.CTSMAPI.CDWithProperties[] lookupConceptCodesByCodeInValueSetWithProperties(string valueSet_id, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit, string[] properties);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByCodeInDomainWithPrope" +
            "rties", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupConceptCodesByCodeInDomainWithPrope" +
            "rtiesResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.NoApplicableValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupConceptCodesByDesignationReturn")]
        InfoWorld.EVS.CTSMAPI.CDWithProperties[] lookupConceptCodesByCodeInDomainWithProperties(string vocabularyDomain_Name, string context, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit, string[] properties);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupValueSet", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupValueSetResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.ValueSetNameIdMismatch), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "ValueSetNameIdMismatch")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupValueSetReturn")]
        InfoWorld.EVS.CTSMAPI.FullValueSetDescription lookupValueSet(InfoWorld.EVS.CTSMAPI.UID in0, InfoWorld.HL7.ITS.ST in1);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupValueSetInfo", ReplyAction = "urn://hl7.org/CTSMAPI/BrowserOperations/lookupValueSetInfoResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.ValueSetNameIdMismatch), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "ValueSetNameIdMismatch")]
        [System.ServiceModel.FaultContractAttribute(typeof(InfoWorld.EVS.CTSMAPI.UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ADXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpprecinct))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostBox))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpbuildingNumberSuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryModeIdentifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryMode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdirection))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationQualifier))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationArea))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryInstallationType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpdeliveryAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcensusTract))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcareOf))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpunitID))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpadditionalLocator))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameType))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetNameBase))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetName))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumberNumeric))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxphouseNumber))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstreetAddressLine))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxppostalCode))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcity))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcounty))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpstate))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.adxpcountry))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ENXP))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enprefix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.engiven))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.enfamily))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.ensuffix))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.endelimiter))]
        [System.ServiceModel.ServiceKnownTypeAttribute(typeof(InfoWorld.HL7.ITS.SC))]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupValueSetReturn")]
        InfoWorld.EVS.CTSMAPI.FullValueSetDescription lookupValueSetInfo(InfoWorld.EVS.CTSMAPI.UID in0, InfoWorld.HL7.ITS.ST in1);
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface BrowserOperationsChannel : BrowserOperations, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class BrowserOperationsClient : System.ServiceModel.ClientBase<BrowserOperations>, BrowserOperations, System.IDisposable
    {
        #region ProxyTool Generated Code

        private BrowserOperationsClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;

        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new BrowserOperationsClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new BrowserOperationsClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new BrowserOperationsClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new BrowserOperationsClient(_endpointConfigurationName);
                else
                    _instance = new BrowserOperationsClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<BrowserOperations>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<BrowserOperations>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<BrowserOperations>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<BrowserOperations>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public BrowserOperationsClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BrowserOperationsClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BrowserOperationsClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BrowserOperationsClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BrowserOperationsClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.ST[] getSupportedMatchAlgorithms()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getSupportedMatchAlgorithms();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getSupportedMatchAlgorithms();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.RIMCodedAttribute[] getSupportedAttributes(InfoWorld.HL7.ITS.ST in0, InfoWorld.HL7.ITS.ST in1, int in2, int in3)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getSupportedAttributes(in0, in1, in2, in3);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getSupportedAttributes(in0, in1, in2, in3);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.ST[] getSupportedVocabularyDomains(InfoWorld.HL7.ITS.ST in0, InfoWorld.HL7.ITS.ST in1, int in2, int in3)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getSupportedVocabularyDomains(in0, in1, in2, in3);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getSupportedVocabularyDomains(in0, in1, in2, in3);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.ValueSetDescriptor[] getSupportedValueSets(InfoWorld.HL7.ITS.ST in0, InfoWorld.HL7.ITS.ST in1, int in2, int in3)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getSupportedValueSets(in0, in1, in2, in3);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getSupportedValueSets(in0, in1, in2, in3);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.CodeSystemDescriptor[] getSupportedCodeSystems(InfoWorld.HL7.ITS.ST in0, InfoWorld.HL7.ITS.ST in1, int in2, int in3)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getSupportedCodeSystems(in0, in1, in2, in3);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getSupportedCodeSystems(in0, in1, in2, in3);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.VocabularyDomainDescription lookupVocabularyDomain(InfoWorld.HL7.ITS.ST in0)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupVocabularyDomain(in0);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupVocabularyDomain(in0);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.CodeSystemInfo lookupCodeSystem(InfoWorld.EVS.CTSMAPI.UID in0, InfoWorld.HL7.ITS.ST in1)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupCodeSystem(in0, in1);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupCodeSystem(in0, in1);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.ValueSetDescriptor lookupValueSetForDomain(InfoWorld.HL7.ITS.ST in0, InfoWorld.HL7.ITS.ST in1)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupValueSetForDomain(in0, in1);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupValueSetForDomain(in0, in1);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.BL isCodeInValueSet(InfoWorld.EVS.CTSMAPI.UID in0, InfoWorld.HL7.ITS.ST in1, InfoWorld.HL7.ITS.BL in2, InfoWorld.EVS.CTSMAPI.ConceptId in3)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.isCodeInValueSet(in0, in1, in2, in3);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.isCodeInValueSet(in0, in1, in2, in3);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.ST getServiceName()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceName();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceName();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.ST getServiceVersion()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceVersion();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceVersion();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.ST getServiceDescription()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceDescription();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceDescription();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.ST getHL7ReleaseVersion()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getHL7ReleaseVersion();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getHL7ReleaseVersion();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.CTSVersionId getCTSVersion()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getCTSVersion();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getCTSVersion();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.CD[] lookupConceptCodesByDesignationInValueSet(string valueSet_id, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupConceptCodesByDesignationInValueSet(valueSet_id, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupConceptCodesByDesignationInValueSet(valueSet_id, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.CDWithProperties[] lookupConceptCodesByDesignationInValueSetWithProperties(string valueSet_id, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit, string[] properties)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupConceptCodesByDesignationInValueSetWithProperties(valueSet_id, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit, properties);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupConceptCodesByDesignationInValueSetWithProperties(valueSet_id, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit, properties);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.CD[] lookupConceptCodesByDesignationInDomain(string vocabularyDomain_Name, string context, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupConceptCodesByDesignationInDomain(vocabularyDomain_Name, context, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupConceptCodesByDesignationInDomain(vocabularyDomain_Name, context, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.CD[] lookupConceptCodesByCodeInValueSet(string valueSet_id, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupConceptCodesByCodeInValueSet(valueSet_id, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupConceptCodesByCodeInValueSet(valueSet_id, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.CD[] lookupConceptCodesByCodeInValueSetWithPaging(string valueSet_id, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit, int minPk, out int lastPkSelected)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupConceptCodesByCodeInValueSetWithPaging(valueSet_id, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit, minPk, out lastPkSelected);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupConceptCodesByCodeInValueSetWithPaging(valueSet_id, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit, minPk, out lastPkSelected);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.HL7.ITS.CD[] lookupConceptCodesByCodeInDomain(string vocabularyDomain_Name, string context, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupConceptCodesByCodeInDomain(vocabularyDomain_Name, context, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupConceptCodesByCodeInDomain(vocabularyDomain_Name, context, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.CDWithProperties[] lookupConceptCodesByCodeInValueSetWithProperties(string valueSet_id, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit, string[] properties)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupConceptCodesByCodeInValueSetWithProperties(valueSet_id, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit, properties);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupConceptCodesByCodeInValueSetWithProperties(valueSet_id, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit, properties);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.CDWithProperties[] lookupConceptCodesByCodeInDomainWithProperties(string vocabularyDomain_Name, string context, string matchText, string matchAlgorithm_code, string language_code, bool activeConceptsOnly, int timeout, int sizeLimit, string[] properties)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupConceptCodesByCodeInDomainWithProperties(vocabularyDomain_Name, context, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit, properties);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupConceptCodesByCodeInDomainWithProperties(vocabularyDomain_Name, context, matchText, matchAlgorithm_code, language_code, activeConceptsOnly, timeout, sizeLimit, properties);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.FullValueSetDescription lookupValueSet(InfoWorld.EVS.CTSMAPI.UID in0, InfoWorld.HL7.ITS.ST in1)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupValueSet(in0, in1);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupValueSet(in0, in1);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InfoWorld.EVS.CTSMAPI.FullValueSetDescription lookupValueSetInfo(InfoWorld.EVS.CTSMAPI.UID in0, InfoWorld.HL7.ITS.ST in1)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupValueSetInfo(in0, in1);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupValueSetInfo(in0, in1);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
