﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.EVS.CTSEdit;
using BMS.Utils;

namespace BMS.ServicesWrapper.Proxy.EVS.Edit
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ServiceModel.ServiceContractAttribute(Namespace = "urn://InfoWorld.org/CTSVocabularyEdit", ConfigurationName = "ICTSEditVocabulary")]
    public interface ICTSEditVocabulary
    {

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditCodeSytem/InsertCodeSystemOrAttribu" +
            "te", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditCodeSytem/InsertCodeSystemOrAttribu" +
            "teResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedCorrespondenceBetweenValue), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedCorrespondenceBetweenValue", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void InsertCodeSystemOrAttribute(InfoWorld.EVS.CTSVAPI.CodeSystemInfo[] codeSystem, bool[] isNew);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditCodeSytem/UpdateCodeSystem", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditCodeSytem/UpdateCodeSystemResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedCorrespondenceBetweenValue), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedCorrespondenceBetweenValue", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfParametersSupplied), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfParametersSupplied", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void UpdateCodeSystem(InfoWorld.EVS.CTSVAPI.CodeSystemIdAndVersions[] codeSystem, string[] codeSystemDescription, string[] fullName);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditCodeSytem/UpdateCodeSystemAttribute" +
            "", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditCodeSytem/UpdateCodeSystemAttribute" +
            "Response")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void UpdateCodeSystemAttribute(string[] codeSystemID, CodeSystemAttribute[][] attribute, string[][] attributeOldValue, string[][] attributeNewValue);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditCodeSytem/DeleteCodeSystem", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditCodeSytem/DeleteCodeSystemResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteCodeSystem(string[] codeSystemID);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditCodeSytem/DeleteCodeSystemAttribute" +
            "", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditCodeSytem/DeleteCodeSystemAttribute" +
            "Response")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteCodeSystemAttribute(string[] codeSystemID, CodeSystemAttribute[][] attribute, string[][] attributeValue);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/InsertConceptOrAttribute", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/InsertConceptOrAttributeRes" +
            "ponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfParametersSupplied), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfParametersSupplied", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedCorrespondenceBetweenValue), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedCorrespondenceBetweenValue", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void InsertConceptOrAttribute(InfoWorld.EVS.CTSVAPI.CompleteCodedConceptDescription[] concept, bool[] isNew);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/InsertConceptWithExpand", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/InsertConceptWithExpandResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfParametersSupplied), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfParametersSupplied", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedCorrespondenceBetweenValue), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedCorrespondenceBetweenValue", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void InsertConceptWithExpand(InfoWorld.EVS.CTSVAPI.CompleteCodedConceptDescription[] concept, bool[] isNew);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/UpdateConcept", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/UpdateConceptResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void UpdateConcept(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, string[] conceptStatus_code);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/UpdateConceptProperty", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/UpdateConceptPropertyRespon" +
            "se")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedCorrespondenceBetweenValue), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedCorrespondenceBetweenValue", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfParametersSupplied), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfParametersSupplied", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void UpdateConceptProperty(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, InfoWorld.EVS.CTSVAPI.ConceptProperty[][] propertiesOld, InfoWorld.EVS.CTSVAPI.ConceptProperty[][] propertiesNew);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/UpdateConceptDesignation", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/UpdateConceptDesignationRes" +
            "ponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfParametersSupplied), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfParametersSupplied", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedCorrespondenceBetweenValue), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedCorrespondenceBetweenValue", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void UpdateConceptDesignation(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, InfoWorld.EVS.CTSVAPI.ConceptDesignation[][] designationsOld, InfoWorld.EVS.CTSVAPI.ConceptDesignation[][] designationsNew);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/DeleteConcept", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/DeleteConceptResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteConcept(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/DeleteConceptWithExpand", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/DeleteConceptWithExpandResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteConceptWithExpand(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/DeleteConceptProperty", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/DeleteConceptPropertyRespon" +
            "se")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteConceptProperty(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, InfoWorld.EVS.CTSVAPI.ConceptProperty[][] properties);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/DeleteConceptDesignation", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/DeleteConceptDesignationRes" +
            "ponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteConceptDesignation(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, InfoWorld.EVS.CTSVAPI.ConceptDesignation[][] designations);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/DeleteConceptAssociation", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditConcept/DeleteConceptAssociationRes" +
            "ponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteConceptAssociation(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, InfoWorld.EVS.CTSVAPI.ConceptRelationship[][] relationships);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditAssociation/DeleteAssociation", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditAssociation/DeleteAssociationRespon" +
            "se")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void DeleteAssociation(Association[] associationsList);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditAssociation/InsertAssociation", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditAssociation/InsertAssociationRespon" +
            "se")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void InsertAssociation(AssociationFullDescription[] associationDescriptionList);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditAssociation/UpdateAssociation", ReplyAction = "urn://InfoWorld.org/CTSVocabularyEdit/ICTSEditAssociation/UpdateAssociationRespon" +
            "se")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedNumberOfAttributes), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedNumberOfAttributes", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(NullMethodeParameterOrNoValueStored), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NullMethodeParameterOrNoValueStored", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        [System.ServiceModel.FaultContractAttribute(typeof(CustomException), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "CustomException", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.EVS.CTSEdit")]
        void UpdateAssociation(AssociationFullDescription[] associationList);
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface ICTSEditVocabularyChannel : ICTSEditVocabulary, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class CTSEditVocabularyClient : System.ServiceModel.ClientBase<ICTSEditVocabulary>, ICTSEditVocabulary, System.IDisposable
    {
        #region ProxyTool Generated Code

        private CTSEditVocabularyClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;


        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new CTSEditVocabularyClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new CTSEditVocabularyClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new CTSEditVocabularyClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new CTSEditVocabularyClient(_endpointConfigurationName);
                else
                    _instance = new CTSEditVocabularyClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<ICTSEditVocabulary>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<ICTSEditVocabulary>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<ICTSEditVocabulary>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<ICTSEditVocabulary>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public CTSEditVocabularyClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CTSEditVocabularyClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CTSEditVocabularyClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CTSEditVocabularyClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CTSEditVocabularyClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertCodeSystemOrAttribute(InfoWorld.EVS.CTSVAPI.CodeSystemInfo[] codeSystem, bool[] isNew)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertCodeSystemOrAttribute(codeSystem, isNew);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertCodeSystemOrAttribute(codeSystem, isNew);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateCodeSystem(InfoWorld.EVS.CTSVAPI.CodeSystemIdAndVersions[] codeSystem, string[] codeSystemDescription, string[] fullName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateCodeSystem(codeSystem, codeSystemDescription, fullName);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateCodeSystem(codeSystem, codeSystemDescription, fullName);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateCodeSystemAttribute(string[] codeSystemID, CodeSystemAttribute[][] attribute, string[][] attributeOldValue, string[][] attributeNewValue)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateCodeSystemAttribute(codeSystemID, attribute, attributeOldValue, attributeNewValue);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateCodeSystemAttribute(codeSystemID, attribute, attributeOldValue, attributeNewValue);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteCodeSystem(string[] codeSystemID)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteCodeSystem(codeSystemID);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteCodeSystem(codeSystemID);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteCodeSystemAttribute(string[] codeSystemID, CodeSystemAttribute[][] attribute, string[][] attributeValue)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteCodeSystemAttribute(codeSystemID, attribute, attributeValue);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteCodeSystemAttribute(codeSystemID, attribute, attributeValue);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertConceptOrAttribute(InfoWorld.EVS.CTSVAPI.CompleteCodedConceptDescription[] concept, bool[] isNew)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertConceptOrAttribute(concept, isNew);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertConceptOrAttribute(concept, isNew);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertConceptWithExpand(InfoWorld.EVS.CTSVAPI.CompleteCodedConceptDescription[] concept, bool[] isNew)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertConceptWithExpand(concept, isNew);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertConceptWithExpand(concept, isNew);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateConcept(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, string[] conceptStatus_code)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateConcept(concept_id, conceptStatus_code);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateConcept(concept_id, conceptStatus_code);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateConceptProperty(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, InfoWorld.EVS.CTSVAPI.ConceptProperty[][] propertiesOld, InfoWorld.EVS.CTSVAPI.ConceptProperty[][] propertiesNew)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateConceptProperty(concept_id, propertiesOld, propertiesNew);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateConceptProperty(concept_id, propertiesOld, propertiesNew);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateConceptDesignation(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, InfoWorld.EVS.CTSVAPI.ConceptDesignation[][] designationsOld, InfoWorld.EVS.CTSVAPI.ConceptDesignation[][] designationsNew)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateConceptDesignation(concept_id, designationsOld, designationsNew);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateConceptDesignation(concept_id, designationsOld, designationsNew);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteConcept(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteConcept(concept_id);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteConcept(concept_id);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteConceptWithExpand(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteConceptWithExpand(concept_id);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteConceptWithExpand(concept_id);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteConceptProperty(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, InfoWorld.EVS.CTSVAPI.ConceptProperty[][] properties)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteConceptProperty(concept_id, properties);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteConceptProperty(concept_id, properties);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteConceptDesignation(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, InfoWorld.EVS.CTSVAPI.ConceptDesignation[][] designations)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteConceptDesignation(concept_id, designations);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteConceptDesignation(concept_id, designations);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteConceptAssociation(InfoWorld.EVS.CTSVAPI.ConceptId[] concept_id, InfoWorld.EVS.CTSVAPI.ConceptRelationship[][] relationships)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteConceptAssociation(concept_id, relationships);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteConceptAssociation(concept_id, relationships);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteAssociation(Association[] associationsList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.DeleteAssociation(associationsList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.DeleteAssociation(associationsList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void InsertAssociation(AssociationFullDescription[] associationDescriptionList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.InsertAssociation(associationDescriptionList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.InsertAssociation(associationDescriptionList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateAssociation(AssociationFullDescription[] associationList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateAssociation(associationList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateAssociation(associationList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<CTSEditVocabularyClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
