﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel.Activities.Description;
using System.ServiceModel.Description;
using System.Text;
using System.Xml.Linq;
using System.ServiceModel;
using System.ServiceModel.Activities;
using Microsoft.Samples.CustomTrackingSample;

namespace BMS.Workflows.PropertyPromotionActivity
{
    public class SqlWorkflowInstanceStorePromotionBehavior : SqlWorkflowInstanceStoreBehavior, IServiceBehavior
    {
        public SqlWorkflowInstanceStorePromotionBehavior(string connectionString)
            : base(connectionString)
        {
        }

        internal SqlWorkflowInstanceStorePromotionBehavior(SqlWorkflowInstanceStoreBehavior sqlWorkflowInstanceStoreBehavior)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                base.ConnectionString = sqlWorkflowInstanceStoreBehavior.ConnectionString;
                base.HostLockRenewalPeriod = sqlWorkflowInstanceStoreBehavior.HostLockRenewalPeriod;
                base.InstanceCompletionAction = sqlWorkflowInstanceStoreBehavior.InstanceCompletionAction;
                base.InstanceEncodingOption = sqlWorkflowInstanceStoreBehavior.InstanceEncodingOption;
                base.InstanceLockedExceptionAction = sqlWorkflowInstanceStoreBehavior.InstanceLockedExceptionAction;
                base.RunnableInstancesDetectionPeriod = sqlWorkflowInstanceStoreBehavior.RunnableInstancesDetectionPeriod;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public SqlWorkflowInstanceStorePromotionBehavior()
        {
        }

        public new void ApplyDispatchBehavior(ServiceDescription serviceDescription, ServiceHostBase serviceHostBase)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (serviceHostBase == null)
                {
                    throw new ArgumentNullException("serviceHostBase");
                }

                WorkflowServiceHost workflowServiceHost = serviceHostBase as WorkflowServiceHost;

                if (workflowServiceHost != null)
                {
                    workflowServiceHost.WorkflowExtensions.Add<PromotionPersistenceParticipant>(() => new PromotionPersistenceParticipant());
                    //workflowServiceHost.WorkflowExtensions.Add(new ConsoleTrackingParticipant());
                }

                base.ApplyDispatchBehavior(serviceDescription, serviceHostBase);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void Promote(string name, IEnumerable<string> promoteAsSqlVariant, IEnumerable<string> promoteAsBinary)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                XNamespace xNS = PromotionPersistenceParticipant.PromotedPropertyXNamespace;
                List<XName> sqlVariantPromotions = null;
                List<XName> binaryPromotions = null;

                if (promoteAsSqlVariant != null)
                {
                    sqlVariantPromotions = new List<XName>();

                    foreach (string propertyName in promoteAsSqlVariant)
                    {
                        sqlVariantPromotions.Add(xNS.GetName(propertyName));
                    }
                }

                if (promoteAsBinary != null)
                {
                    binaryPromotions = new List<XName>();

                    foreach (string propertyName in promoteAsBinary)
                    {
                        binaryPromotions.Add(xNS.GetName(propertyName));
                    }
                }

                base.Promote(name, sqlVariantPromotions, binaryPromotions);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
