﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using FC = BMS.Facade.Data;
using DC = BMS.DataContracts;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.WF;
using BMS.Utils;
using System.ServiceModel;
using BMS.Facade.Fault;
using BMS.ServicesWrapper.BMService;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.WF
{
    /// <summary>
    /// The scheduled admission writer.
    /// </summary>
    class ScheduledAdmissionWriter : BaseWorkFlowWriter<ScheduledAdmission>
    {
        private DC.ScheduledAdmission Translate(ScheduledAdmission entity)
        {
            FC.Ward ward = InsertIfNullOrUpdateIfDirty<WardLocation, FC.Ward>(entity.Ward);
            CD specialty = InsertIfNullOrUpdateIfDirty<FacilityTreatingSpecialty, CD>(entity.TreatingSpecialty);
            CD medicalCenterDivision = InsertIfNullOrUpdateIfDirty<MedicalCenterDivision, CD>(entity.MedicalCenterDivision);            
            string domainId = BMS.ServicesWrapper.Security.SecurityFactory.InstanceWindows.GetCurrentDomain();

            DC.ScheduledAdmission scheduledAdmission = new DC.ScheduledAdmission()
            {
                Id = new II(domainId, null),
                Diagnosis = entity.AdmittingDiagnosis,
                CanceledDate = entity.DateTimeCancelled,
                WardId = ward != null ? ward.Id : null,
                IEN = entity.IEN,
                LOSExpected = (entity.LengthOfStayExpected.HasValue) ? entity.LengthOfStayExpected.Value : 0,
                PatientId = MakePatient(entity.Patient),
                ReservationDate = entity.ReservationDateTime,
                Surgery = (entity.Surgery == null || entity.Surgery.ToUpper().Equals("N") || entity.Surgery.ToUpper().Equals("NO")) ? false : true,
                Speciality = specialty,
                VistaDivision = medicalCenterDivision,
                SchedulerId = MakePerson(entity.Scheduler),
                ProviderId = MakePerson(entity.Provider),
                VistaSiteId = (VistaSite != null) ? VistaSite.Id : null
            };
            ConvertToUtc(scheduledAdmission);
            return scheduledAdmission;
        }

        /// <summary>
        /// Sends the event.
        /// </summary>
        /// <param name="entity">The entity.</param>
        protected override bool SendEvent(ScheduledAdmission entity)
        {            
            DC.ScheduledAdmission scheduledAdmission = Translate(entity);
            BMSFactory.BedManagerOperationsClientWindows.CreateScheduledAdmission(scheduledAdmission);
            Logger.LogFormat(BmsLogger.Level.Info, "Create scheduled admission for patient {0} with succes", entity.Patient.Name);            
            return true;
        }

        protected override DC.VistaIntegrationLog MakeLog(ScheduledAdmission entity)
        {
            return new DC.VistaIntegrationLog()
            {
                File = DC.VistaFiles.ScheduledAdmission,
                Ien = entity.IEN
            };
        }
    }
}
