﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;

using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.ServicesWrapper.EVS;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.EVS
{

    /// <summary>
    /// The treating specialty writer.
    /// </summary>
    class TreatingSpecialtyWriter : BaseEvsWriter<FacilityTreatingSpecialty>
    {

        protected override string CodeSystem
        {
            get { return Constants.VistaTreatingSpecialtyCodeSystem; }
        }

        protected override string CodeSystemName
        {
            get { return Util.Vocabulary.VistaTreatingSpecialty.ToString(); }
        }

        protected override IEntityDal<CD> Dal
        {
            get { return Data.TreatingSpecialtyDal; }
        }

        public override void InitCache()
        {
            Data.SetCacheForTreatingSpecialty();
        }
    }
}
