﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using FC = BMS.Facade.Data;
using BMS.Utils;
using InfoWorld.HL7.ITS;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.EIS
{
    class NewPersonWriter : BaseEisWriter<NewPerson, FC.Person>
    {
        protected override IEntityDal<FC.Person> Dal
        {
            get { return Data.PersonDal; }
        }

        private Dictionary<string, string> names;

        protected override FC.Person GetBmsEntity(NewPerson entity)
        {
            if (entity.Name == null)
                entity.Name = string.Empty;
            names = Utilities.SplitPersonFullName(entity.Name);
            return base.GetBmsEntity(entity);
        }

        protected override void TranslateFromVistaToBMS(NewPerson person, FC.Person bmsEntity)
        {
            bmsEntity.Ien = person.IEN;
            bmsEntity.FirstName = names[Constants.PERSON_FIRST_NAME];
            bmsEntity.MiddleName = names[Constants.PERSON_MIDDLE_NAME];
            bmsEntity.LastName = names[Constants.PERSON_LAST_NAME];
            bmsEntity.VistaSite = new II() { root = EISConstants.SITE, extension = VistaSite.Id.extension };
        }

        protected override bool AreFieldsEqual(NewPerson entity, FC.Person bmsEntity)
        {
            return bmsEntity.FirstName == names[Constants.PERSON_FIRST_NAME] &&
                   bmsEntity.LastName == names[Constants.PERSON_LAST_NAME] &&
                   bmsEntity.MiddleName == names[Constants.PERSON_MIDDLE_NAME];
        }

        public override void InitCache()
        {
        }
    }
}
