﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper;
using BMS.ServicesWrapper.EVS;
using BMS.Facade.Data;
using BMS.VistaIntegration.Data;
namespace BMS.VistaWorker2.Writer.Implementation.Concrete.Dal
{
    public class GlobalEvsDal : BaseDal<CD>
    {
        public string CodeSystemName { get; private set; }

        public GlobalEvsDal(VistaSite site, string codeSystemName)
            : base(site)
        {
            this.CodeSystemName = codeSystemName;
        }


        public override CD Get(IEntity vistaEntity)
        {
            string ien = vistaEntity.IEN;
            return EVS.GetCodes(new CodeFilterParameters() { VocabularyDomain = CodeSystemName, MaxSelectedCodes = int.MaxValue }).FirstOrDefault(s => s.code == ien);
        }

        public override void Add(IEntity vistaEntity, CD entity)
        {
            if (entity.codeSystemName.Equals(Util.Vocabulary.VistaMedicalCenterDivision.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.InsertMedicalCenterDivision(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.OrderableItem.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.InsertOrderableItem(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.VistaSpecialty.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.InsertSpecialty(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.VistaTreatingSpecialty.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.InsertTreatingSpecialty(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.TypeOfMovement.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.InsertFacilityMovementType(entity, Site.Code);
        }

        public override void Delete(IEntity vistaEntity, CD entity)
        {
            EVS.DeleteConcept(entity);
        }

        public override void Update(IEntity vistaEntity, CD entity)
        {
            if (entity.codeSystemName.Equals(Util.Vocabulary.VistaMedicalCenterDivision.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.UpdateMedicalCenterDivision(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.OrderableItem.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.UpdateOrderableItem(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.VistaSpecialty.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.UpdateSpecialty(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.VistaTreatingSpecialty.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.UpdateTreatingSpecialty(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.TypeOfMovement.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.UpdateFacilityMovementType(entity, Site.Code);
        }
    }
}
