﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using InfoWorld.HL7.ITS;

namespace BMS.VistaWorker2.Writer
{
    /// <summary>
    /// Interface responsbile for creating and returning specialized entity writers.
    /// </summary>
    public interface IWriterManager
    {
        /// <summary>
        /// Gets the site id.
        /// </summary>
        VistASite Site { get; }

        BMS.VistaWorker2.Writer.Implementation.Concrete.WF.Utils UtilsInstance { get; }

        /// <summary>
        /// Initiates the underlying writer with its entity writers.
        /// </summary>
        void Open(VistASite site);

        /// <summary>
        /// Closes the underlying writer.
        /// </summary>
        void Close();

        /// <summary>
        /// Makes the entity writer.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <returns></returns>
        IEntityWriter<T> MakeEntityWriter<T>();

    }
}