﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Exceptions;
using System.ServiceModel;
using BMS.Facade.Fault;

namespace BMS.VistaWorker.Writer.Concrete.CatchExceptions.Concrete
{
    class CatchWfExceptions : CommonCatchExceptions
    {
        protected override void MapExceptions()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MapAbort<FaultException<GenericWFServiceFault>>(e => e.Detail.ToString());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
