﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using BMS.VistaWorker.Exceptions;
using InfoWorld.EIS.FaultContracts;
using BMS.Facade.Fault;

namespace BMS.VistaWorker.Writer.Concrete.CatchExceptions.Concrete
{
    class CatchEisExceptions : CommonCatchExceptions
    {
        protected override void MapExceptions()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Retry();
                Stop();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void Retry()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MapRetryFaultException<NoEntityFound>();
                MapRetryFaultException<EntityIsActive>();
                MapRetryFaultException<EntityIsInactive>();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MapAbort<FaultException<GenericWFServiceFault>>(e => e.Detail.ToString());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void Stop()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MapStopFaultException<AuthorizationReadDenied>();
                MapStopFaultException<AuthorizationUpdateDenied>();
                MapStopFaultException<CustomException>();
                MapStopFaultException<DataTypeUnknown>();
                MapStopFaultException<DefaultFaultContract>();
                MapStopFaultException<DomainIdentifierDoesNotExist>();
                MapStopFaultException<EntityIdentifierDoesNotExist>();
                MapStopFaultException<EntityIdentifierMustBeUniqueForEntityTypeOnDomain>();
                MapStopFaultException<EntityIdentifierNotAssignedToEntityTypeOnDomain>();
                MapStopFaultException<EntityTypeClassifierIdentifierDoesNotExist>();
                MapStopFaultException<EntityTypeIdentifierDoesNotExist>();
                MapStopFaultException<EntityTypeNotAssignedToDomain>();
                MapStopFaultException<FunctionForMatchAlreadyExists>();
                MapStopFaultException<FunctionForMatchDoesNotExists>();
                MapStopFaultException<FunctionForMatchIsInUseByLinkAlgorithm>();
                MapStopFaultException<FunctionForMatchUnknown>();
                MapStopFaultException<IdentifierMustBeUnique>();
                MapStopFaultException<InsufficientTraits>();
                MapStopFaultException<InvalidDataTypeForTrait>();
                MapStopFaultException<InvalidValueForTrait>();
                MapStopFaultException<LinkAlreadyExist>();
                MapStopFaultException<LinkDoesNotExist>();
                MapStopFaultException<LinkTraitAlreadyAssignedToEntityType>();
                MapStopFaultException<LinkTraitDoesNotExists>();
                MapStopFaultException<MatchingAlgorithmNotSupported>();
                MapStopFaultException<MismatchBetweenNumberOfDomainAndMandatoryIndicators>();
                MapStopFaultException<NoNotification>();
                MapStopFaultException<NullMethodeParameterOrNoValueStored>();
                MapStopFaultException<TraitIdentifierDoesNotExist>();
                MapStopFaultException<TraitListDuplicates>();
                MapStopFaultException<TraitNotAssignedToDomain>();
                MapStopFaultException<TraitNotAssignedToEntityType>();
                MapStopFaultException<TraitNotAssignedToEntityTypeOnDomain>();
                MapStopFaultException<UndoMergeUndeterministic>();
                MapStopFaultException<UnexpectedError>();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }



    }
}
