﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Writer.Concrete.CatchExceptions.Concrete;

namespace BMS.VistaWorker.Writer.Concrete.CatchExceptions
{
    /// <summary>
    /// Factory for CachExceptions class.
    /// </summary>
    static class CatchExceptionFactory
    {
        private static ICatchExceptions catchEis = new CatchEisExceptions();
        private static ICatchExceptions catchEvs = new CatchEvsExceptions();
        private static ICatchExceptions catchWf = new CatchWfExceptions();

        /// <summary>
        /// Gets the CachExceptions class for EIS.
        /// </summary>
        public static ICatchExceptions CatchEisExceptions { get { return catchEis; } }

        /// <summary>
        /// Gets the CachExceptions class for EVS.
        /// </summary>
        public static ICatchExceptions CatchEvsExceptions { get { return catchEvs; } }

        /// <summary>
        /// Gets the CachExceptions class for work flow.
        /// </summary>
        public static ICatchExceptions CatchWfExceptions { get { return catchWf; } }

    }
}
