﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Abstract;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.EVS;
using BMS.ServicesWrapper.EIS;
using BMS.Utils;
using SC = BMS.DataContracts;
using FC = BMS.Facade.Data;
using BMS.VistaWorker.Writer.Abstract;
using BMS.VistaWorker.Writer.Concrete.CatchExceptions;
using System.ServiceModel;
using BMS.Facade.Fault;
using BMS.Facade;


namespace BMS.VistaWorker.Writer.Concrete
{
    /// <summary>
    /// Abstract base writer for workflow entities.
    /// </summary>
    /// <typeparam name="T"></typeparam>
    abstract class BaseWorkFlowWriter<T> : BaseEntityWriter<T> where T : IEntity
    {

        public BaseWorkFlowWriter() : base(CatchExceptionFactory.CatchWfExceptions) { }

        /// <summary>
        /// Sends the event.
        /// </summary>
        /// <param name="entity">The entity.</param>
        protected abstract void SendEvent(T entity);

        protected override void OnInsert(T entity)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                throw new InvalidOperationException();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected override void OnDelete(T entity)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                throw new InvalidOperationException();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected override void OnUpdate(T entity)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SendEvent(entity);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        private FC.Patient GetPatient(Patient patient)
        {
            FC.Patient fcPatient = EIS.GetPatientBySsn(new II() { root = Constants.SSNROOT, extension = patient.SocialSecurityNumber }, null);
            if (fcPatient == null)
            {
                fcPatient = new FC.Patient();
                PatientWriter.TranslatePatientFromVistAToBMS(patient, fcPatient,VistaSite);
                EIS.CreatePatient(fcPatient);
            }
            return fcPatient;
        }

        /// <summary>
        /// Makes the wf patient.
        /// </summary>
        /// <param name="patient">The patient.</param>
        /// <returns></returns>
        protected II MakeWfPatient(Patient wfPatient)
        {
            if (wfPatient == null) return null;
            FC.Patient patient = GetPatient(wfPatient);
            if (patient != null)
                return patient.Id;
            return null;            
        }
    }
}
