﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaWorker.Exceptions
{
    /// <summary>
    /// Indicates that the worker will cancel processing the entity and will delete it from the log.
    /// </summary>
    [Serializable]
    public class AbortEntityProcessingException : Exception
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="AbortEntityProcessingException"/> class.
        /// </summary>
        public AbortEntityProcessingException() { }

        /// <summary>
        /// Initializes a new instance of the <see cref="AbortEntityProcessingException"/> class with a specified error message.
        /// </summary>
        /// <param name="message">The message that describes the error.</param>
        public AbortEntityProcessingException(string message) : base(message) { }

        /// <summary>
        /// Initializes a new instance of the <see cref="AbortEntityProcessingException"/> class with a specified
        /// error message and a reference to the inner exception that is the cause of this exception.
        /// </summary>
        /// <param name="message">The error message that explains the reason for the exception.</param>
        /// <param name="innerException">The exception that is the cause of the current exception, or a null reference if no inner exception is specified.</param>
        public AbortEntityProcessingException(string message, Exception innerException)
            : base(message, innerException)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AbortEntityProcessingException"/> class with serialized data.
        /// </summary>
        /// <param name="info">The <see cref="T:System.Runtime.Serialization.SerializationInfo"/> that holds the serialized object data about the exception being thrown.</param>
        /// <param name="context">The <see cref="T:System.Runtime.Serialization.StreamingContext"/> that contains contextual information about the source or destination.</param>
        protected AbortEntityProcessingException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }
    }
}
