﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista patient appointment entity
    /// </summary>
    [Serializable]
    public class PatientAppointment : IEntity
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the appointment date time.
        /// </summary>
        /// <value>
        /// The appointment date time.
        /// </value>
        public DateTime AppointmentDateTime { get; set; }

        /// <summary>
        /// Gets or sets the hospital location id (IEN).
        /// </summary>
        /// <value>
        /// The hospital location id.
        /// </value>
        public string HospitalLocationId { get; set; }

        /// <summary>
        /// Gets or sets the hospital location telephone.
        /// </summary>
        /// <value>
        /// The hospital location telephone.
        /// </value>
        public string HospitalLocationTelephone { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the data entry clerk.
        /// </summary>
        /// <value>
        /// The data entry clerk.
        /// </value>
        public string DataEntryClerk { get; set; }

        /// <summary>
        /// Gets or sets the date appointment made.
        /// </summary>
        /// <value>
        /// The date appointment made.
        /// </value>
        public DateTime DateAppointmentMade { get; set; }

        /// <summary>
        /// Gets or sets the current status.
        /// </summary>
        /// <value>
        /// The current status.
        /// </value>
        public string CurrentStatus { get; set; }

        /// <summary>
        /// Gets or sets the patient id (IEN).
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        public string PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        public Patient Patient { get; set; }

    }
}
