﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Data;

namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// The workflow data log.
    /// </summary>
    public class WorkFlowLog : BaseWfLogData
    {
        private IEntity _entity;

        public override int Id
        {
            get;
            set;
        }


        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public override DateTime CreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the order id.
        /// </summary>
        /// <value>
        /// The order id.
        /// </value>
        public string OrderId { get { return OrderIdInt.HasValue ? OrderIdInt.Value + "" : null; } }

        /// <summary>
        /// Gets or sets the order id.
        /// </summary>
        /// <value>
        /// The order id.
        /// </value>
        public int? OrderIdInt { get; set; }

        /// <summary>
        /// Gets or sets the patient appointment id (IEN).
        /// </summary>
        /// <value>
        /// The patient appointment id.
        /// </value>
        public string PatientAppointmentId { get { return PatientAppointmentIdInt.HasValue ? PatientAppointmentIdInt.Value + "" : null; } }

        /// <summary>
        /// Gets or sets the patient appointment id (IEN).
        /// </summary>
        /// <value>
        /// The patient appointment id.
        /// </value>
        public int? PatientAppointmentIdInt { get; set; }

        /// <summary>
        /// Gets or sets the patient movement id (IEN).
        /// </summary>
        /// <value>
        /// The patient movement id.
        /// </value>
        public string PatientMovementId { get { return PatientMovementIdInt.HasValue ? PatientMovementIdInt.Value + "" : null; } }

        /// <summary>
        /// Gets or sets the patient movement id (IEN).
        /// </summary>
        /// <value>
        /// The patient movement id.
        /// </value>
        public int? PatientMovementIdInt { get; set; }

        /// <summary>
        /// Gets or sets the scheduled admission id (IEN).
        /// </summary>
        /// <value>
        /// The scheduled admission id.
        /// </value>
        public string ScheduledAdmissionId { get { return ScheduledAdmissionIdInt.HasValue ? ScheduledAdmissionIdInt.Value + "" : null; } }

        /// <summary>
        /// Gets or sets the scheduled admission id (IEN).
        /// </summary>
        /// <value>
        /// The scheduled admission id.
        /// </value>
        public int? ScheduledAdmissionIdInt { get; set; }

        /// <summary>
        /// Gets or sets the order.
        /// </summary>
        /// <value>
        /// The order.
        /// </value>
        public Order Order { get { return _entity as Order; } set { _entity = value; } }

        /// <summary>
        /// Gets or sets the patient appointment.
        /// </summary>
        /// <value>
        /// The patient appointment.
        /// </value>
        public PatientAppointment PatientAppointment { get { return _entity as PatientAppointment; } set { _entity = value; } }

        /// <summary>
        /// Gets or sets the patient movemenet.
        /// </summary>
        /// <value>
        /// The patient movemenet.
        /// </value>
        public PatientMovement PatientMovement { get { return _entity as PatientMovement; } set { _entity = value; } }

        /// <summary>
        /// Gets or sets the scheduled admission.
        /// </summary>
        /// <value>
        /// The scheduled admission.
        /// </value>
        public ScheduledAdmission ScheduledAdmission { get { return _entity as ScheduledAdmission; } set { _entity = value; } }


        public override IEntity Entity
        {
            get { return _entity; }
        }


    }
}
