﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Reader.LogTables;

namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// The orders orederable item log data.
    /// </summary>
    public class OrdersOrderableItemLog : BaseLogData<OrdersOrderableItemLog,OrdersOrderableItem>
    {


        /// <summary>
        /// Gets the crud action.
        /// </summary>
        public override CrudAction CrudAction { get;  set; }



        /// <summary>
        /// Gets the id.
        /// </summary>
        public override int Id { get; set; }
        /// <summary>
        /// Gets or sets the action.
        /// </summary>
        /// <value>
        /// The action.
        /// </value>
        public char Action { get { return TranslateCrudAction.ToChar(CrudAction); } set { CrudAction = TranslateCrudAction.ToEnum(value); } }
        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public override DateTime CreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the order id.
        /// </summary>
        /// <value>
        /// The order id.
        /// </value>
        public int OrderId { get { return entity.OrderId; } set { entity.OrderId = value; } }
        /// <summary>
        /// Gets or sets the orderable item id.
        /// </summary>
        /// <value>
        /// The orderable item id.
        /// </value>
        public int OrderableItemId { get { return entity.OrderableItemId; } set { entity.OrderableItemId = value; } }

    }
}
