﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Reader.LogTables;

namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// The order status log data.
    /// </summary>
    public class OrderStatusLog : BaseLogData<OrderStatusLog,OrderStatus>
    {

        /// <summary>
        /// Gets the crud action.
        /// </summary>
        public override CrudAction CrudAction { get; set; }



        /// <summary>
        /// Gets the id.
        /// </summary>
        public override int Id { get; set; }
        /// <summary>
        /// Gets or sets the action.
        /// </summary>
        /// <value>
        /// The action.
        /// </value>
        public char Action { get { return TranslateCrudAction.ToChar(CrudAction); } set { CrudAction = TranslateCrudAction.ToEnum(value); } }
        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public override DateTime CreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public int IEN { get { return entity.IEN; } set { entity.IEN = value; } }
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public String Name { get { return entity.Name; } set { entity.Name = value; } }



    }
}
