﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Reader.Abstract;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// Base class for log data entity.
    /// </summary>
    /// <typeparam name="T"></typeparam>
    /// <typeparam name="E"></typeparam>
    public abstract class BaseLogData : ILogData
    {

        /// <summary>
        /// Gets the entity.
        /// </summary>
        public abstract IEntity Entity
        {
            get;
        }


        /// <summary>
        /// Gets the id.
        /// </summary>
        public abstract int Id
        {
            get;
            set;
        }

        /// <summary>
        /// Gets the crud action.
        /// </summary>
        public abstract CrudAction CrudAction
        {
            get;
            set;
        }

        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public abstract DateTime CreateDateTime
        {
            get;
            set;
        }

    }
}
