﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;


namespace BMS.VistaWorker.Reader.Abstract
{
    /// <summary>
    /// Indicates that the worker cannot connect to vista db.
    /// </summary>

    [Serializable]
    class RetryVistaException : Exception
    {

        /// <summary>
        /// Initializes a new instance of the <see cref="RetryVistaException"/> class.
        /// </summary>
        public RetryVistaException() { }


        /// <summary>
        /// Initializes a new instance of the <see cref="RetryVistaException"/> class with a specified error message.
        /// </summary>
        /// <param name="message">The message that describes the error.</param>
        public RetryVistaException(string message) : base(message) { }

        /// <summary>
        /// Initializes a new instance of the <see cref="RetryVistaException"/> class with a specified
        /// error message and a reference to the inner exception that is the cause of this exception.
        /// </summary>
        /// <param name="message">The error message that explains the reason for the exception.</param>
        /// <param name="innerException">The exception that is the cause of the current exception, or a null reference if no inner exception is specified.</param>
        public RetryVistaException(string message, Exception innerException)
            : base(message, innerException)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="RetryVistaException"/> class with serialized data.
        /// </summary>
        /// <param name="info">The <see cref="T:System.Runtime.Serialization.SerializationInfo"/> that holds the serialized object data about the exception being thrown.</param>
        /// <param name="context">The <see cref="T:System.Runtime.Serialization.StreamingContext"/> that contains contextual information about the source or destination.</param>
        protected RetryVistaException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }
    }
}
