﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using System.Globalization;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.Mdws2.Maps.EIS
{
    public class PatientMap : FileMap<Patient>
    {
        private static readonly PatientMap instance = new PatientMap();
        public static PatientMap Instance { get { return instance; } }

        private PatientMap()
        {
        }


        public override string FileNumber
        {
            get { return "2"; }
        }

        protected override void Map()
        {
                MapIen((e, value) => e.IEN = value);
                Map((e, value) => e.Name = value, ".01");
                Map((e, value) => e.DateOfBirth = value.VistAToDateTime(), ".03");
                Map((e, value) => e.Name1U4N = value, ".0905");
                Map((e, value) => e.Sex = value[0], ".02");
                Map((e, value) => e.SocialSecurityNumber = GetSsn(value), ".09");
                Map((e, value) => e.TreatingSpecialtyId = value, ".103");
        }

        private static string GetSsn(string value)
        {
                StringBuilder sb = new StringBuilder(15);
                sb.Append(value, 0, 3);
                sb.Append('-');
                sb.Append(value, 3, 2);
                sb.Append('-');
                sb.Append(value, 5, value.Length - 5);
                return sb.ToString();
        }
    }
}
