﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.WF;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Mdws2.QuerySvcService;
using BMS.VistaIntegration.Mdws2.Maps.EIS;

namespace BMS.VistaIntegration.Mdws2.Implementation.WF
{
    public class SinglePatientAppointmentCommand : BaseCommand<PatientAppointment>
    {
        public string PatientIen { get; set; }
        public IEnumerable<string> ClinicIens { get; set; }
        private Patient patient;

        public SinglePatientAppointmentCommand()
            : base(PatientAppointmentPatientMap.Instance)
        {
    
        }

        private Predicate<PatientAppointment> NoClinicIens()
        {
            return (p) =>
            {
                p.PatientId = patient.IEN;
                p.Patient = patient;
                return true;
            };
        }

        private Predicate<PatientAppointment> OnlyOneClinicIen()
        {
            string clinicIen = ClinicIens.First();
            return (p) =>
            {
                p.Patient = patient;
                p.PatientId = patient.IEN;
                return p.HospitalLocationId == clinicIen;
            };
        }

        private Predicate<PatientAppointment> MoreThanOneClinicIen()
        {
            HashSet<string> clinicHash = new HashSet<string>(ClinicIens);
            return (p) =>
            {
                p.Patient = patient;
                p.PatientId = patient.IEN;
                return clinicHash.Contains(p.HospitalLocationId);
            };
        }

        protected override Predicate<PatientAppointment> GetPredicate()
        {
            if (ClinicIens == null) return NoClinicIens();
            int length = ClinicIens.Count();
            if (length == 1) return OnlyOneClinicIen();
            return MoreThanOneClinicIen();
        }

        protected override string Ien
        {
            get
            {
                return ',' + PatientIen;
            }
        }

        private const string StartDateScreen = "I Y>={0}";
        private const string EndDateScreen = "I Y<{0}";
        private const string StartEndDateScreen = "I (Y>={0})&(Y<{1})";

        protected override string GetScreenParam()
        {
            if (StartDate.HasValue && EndDate.HasValue)
                return string.Format(StartEndDateScreen, StartDate.Value.VistAToInternalFormat(), EndDate.Value.VistAToInternalFormat());

            if (StartDate.HasValue)
                return string.Format(StartDateScreen, StartDate.Value.VistAToInternalFormat());

            if (EndDate.HasValue)
                return string.Format(EndDateScreen, EndDate.Value.VistAToInternalFormat());

            return string.Empty;
        }

        public override IList<PatientAppointment> Execute(QuerySvcSoap client)
        {
            if (PatientIen == null)
                throw new InvalidOperationException();


            SingleFileFetch<Patient> singleFetch = new SingleFileFetch<Patient>(PatientMap.Instance);
            singleFetch.Ien = PatientIen;
            singleFetch.Client = client;
            patient = singleFetch.GetResult();
            return base.Execute(client);
        }






    }
}
