﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.VistaIntegration.Data
{
    [Serializable]
    public class AdmittedPatient : IEntity
    {
        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the SSN.
        /// </summary>
        /// <value>
        /// The SSN.
        /// </value>
        public string SSN { get; set; }

        /// <summary>
        /// Gets or sets the admission ien.
        /// </summary>
        /// <value>
        /// The admission ien.
        /// </value>
        public string AdmissionIen { get; set; }

        /// <summary>
        /// Gets or sets the movement ien.
        /// </summary>
        /// <value>
        /// The movement ien.
        /// </value>
        public string MovementIen { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the name of the bed.
        /// </summary>
        /// <value>
        /// The name of the bed.
        /// </value>
        public string BedName { get; set; }
    }
}
