﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;

namespace BMS.VistaIntegration.Cache.Commands
{
    public class CacheCommandInfo
    {
        public CacheCommandInfo(string commandQuery)
        {
            this.HasMore = true;
            this.CommandQuery = commandQuery;
            this.LastIen = "0";
            this.IsBedHoldSupported = true;
        }
        
        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        public DateTime? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        public DateTime? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the row count.
        /// </summary>
        /// <value>
        /// The row count.
        /// </value>
        public int? RowCount { get; set; }

        /// <summary>
        /// Gets or sets the last ien.
        /// </summary>
        /// <value>
        /// The last ien.
        /// </value>
        public string LastIen { get; set; }

        /// <summary>
        /// Gets or sets from ien.
        /// </summary>
        /// <value>
        /// From ien.
        /// </value>
        public string FromIen { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance has more.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance has more; otherwise, <c>false</c>.
        /// </value>
        public bool HasMore { get; set; }

        /// <summary>
        /// Gets or sets the command query.
        /// </summary>
        /// <value>
        /// The command query.
        /// </value>
        public string CommandQuery { get; set; }

        /// <summary>
        /// Gets or sets the ien.
        /// </summary>
        /// <value>
        /// The ien.
        /// </value>
        public string Ien { get; set; }
        
        /// <summary>
        /// Gets or sets the orderable items ien.
        /// </summary>
        /// <value>
        /// The orderable items ien.
        /// </value>
        public IEnumerable<string> OrderableItemsIen { get; set; }

        /// <summary>
        /// Gets or sets the clinics ien.
        /// </summary>
        /// <value>
        /// The clinics ien.
        /// </value>
        public IEnumerable<string> ClinicsIen { get; set; }

        /// <summary>
        /// Gets or sets the type of the transaction.
        /// </summary>
        /// <value>
        /// The type of the transaction.
        /// </value>
        public MovementTransactionType TransactionType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is bed hold supported.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is bed hold supported; otherwise, <c>false</c>.
        /// </value>
        public bool IsBedHoldSupported { get; set; }

        /// <summary>
        /// Gets or sets the patient SSNS.
        /// </summary>
        /// <value>
        /// The patient SSNS.
        /// </value>
        public string PatientSsns { get; set; }
    }
}
