﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using System.Runtime.Serialization;

namespace BMS.FaultContracts
{
    /// <summary>
    /// Fault contract used on update and delete operations for entities not found in the database.
    /// </summary>
    [DataContract]
    public class EntityNotFoundException
    {
        /// <summary>
        /// Gets or sets the type of the method(CRUDE).
        /// </summary>
        /// <value>
        /// The type of the method.
        /// </value>
        [DataMember]
        public MethodType MethodType { get; set; }

        /// <summary>
        /// Gets or sets the error message.
        /// </summary>
        /// <value>
        /// The error message.
        /// </value>
        [DataMember]
        public string ErrorMessage { get; set; }

        /// <summary>
        /// Override ToString().
        /// </summary>
        /// <returns>Friendly print of the exception.</returns>
        public override string ToString()
        {
            return ErrorMessage
                + MethodType != null ? String.Empty : "  MethodType = " + MethodType.ToString()
                ;
        }
    }
}
