﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.FaultContracts
{
    /// <summary>
    /// Custom SQL Fault used for excetions from stored procedures.
    /// </summary>
    [DataContract]
    public class CustomSQLException
    {
        /// <summary>
        /// Gets or sets the name of the stored procedure.
        /// </summary>
        /// <value>
        /// The name of the stored procedure.
        /// </value>
        [DataMember]
        public string SPName { get; set; }

        /// <summary>
        /// Gets or sets the error message.
        /// </summary>
        /// <value>
        /// The error message.
        /// </value>
        [DataMember]
        public string ErrorMessage { get; set; }

        /// <summary>
        /// Gets or sets the line number from the stored procedure where the exception occurred.
        /// </summary>
        /// <value>
        /// The line number.
        /// </value>
        [DataMember]
        public int LineNumber { get; set; }
        /// <summary>
        /// Override ToString().
        /// </summary>
        /// <returns>Friendly print of the exception.</returns>
        public override string ToString()
        {
            return ErrorMessage
                + (String.IsNullOrEmpty(SPName) ? String.Empty : "  SPName = " + SPName)
                + "  LineNumber = " + LineNumber.ToString()
                ;
        }
    }
}
