﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.Xml.Serialization;

namespace BMS.DataContracts
{
    /// <summary>
    /// Represents a new event containing name and count.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "NewEvent")]
    [DataContract(Name = "NewEvent")]
    public class NewEvent
    {
        /// <summary>
        /// Gets or sets the name of the event.
        /// </summary>
        /// <value>
        /// The name of the event.
        /// </value>
        [XmlElementAttribute("EventName", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "EventName", Order = 1)]
        public Utils.NewEvent EventName { get; set; }

        /// <summary>
        /// Gets or sets the event count.
        /// </summary>
        /// <value>
        /// The event count.
        /// </value>
        [XmlElementAttribute("EventCount", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "EventCount", Order = 2)]
        public int EventCount { get; set; }

        /// <summary>
        /// Gets or sets the total count.
        /// </summary>
        /// <value>
        /// The total count.
        /// </value>
        [XmlElementAttribute("TotalCount", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "TotalCount", Order = 3)]
        public int TotalCount { get; set; }
    }
}
