﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Icon Association class used for CRUD.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "IconAssociation")]
    [DataContract(Name = "IconAssociation")]
    [KnownType(typeof(II))]
    public class IconAssociation
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        [XmlElementAttribute("BedId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 1)]
        public II BedId { get; set; }

        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 2)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 3)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets the list icon flag ids of bed.
        /// </summary>
        /// <value>
        /// The list icon flag ids of bed.
        /// </value>
        [XmlElementAttribute("ListIconFlagIdsOfBed", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "ListIconFlagIdsOfBed", Order = 4)]
        public List<int> ListIconFlagIdsOfBed { get; set; }

        /// <summary>
        /// Gets or sets the list icon flag ids of patient.
        /// </summary>
        /// <value>
        /// The list icon flag ids of patient.
        /// </value>
        [XmlElementAttribute("ListIconFlagIdsOfPatient", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "ListIconFlagIdsOfPatient", Order = 5)]
        public List<int> ListIconFlagIdsOfPatient { get; set; }

        /// <summary>
        /// Gets or sets the list icon flag facility ids of bed.
        /// </summary>
        /// <value>
        /// The list icon flag facility ids of bed.
        /// </value>
        [XmlElementAttribute("ListIconFlagFacilityIdsOfBed", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "ListIconFlagFacilityIdsOfBed", Order = 6)]
        public List<int> ListIconFlagFacilityIdsOfBed { get; set; }

        /// <summary>
        /// Gets or sets the list icon flag facility ids of patient.
        /// </summary>
        /// <value>
        /// The list icon flag facility ids of patient.
        /// </value>
        [XmlElementAttribute("ListIconFlagFacilityIdsOfPatient", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "ListIconFlagFacilityIdsOfPatient", Order = 7)]
        public List<int> ListIconFlagFacilityIdsOfPatient { get; set; }

        /// <summary>
        /// Gets or sets the waiting list patient id.
        /// </summary>
        /// <value>
        /// The waiting list patient id.
        /// </value>
        [XmlElementAttribute("WaitingListPatientId", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "WaitingListPatientId", Order = 8)]
        public II WaitingListPatientId { get; set; }

        /// <summary>
        /// Gets or sets the waiting list info.
        /// </summary>
        /// <value>
        /// The waiting list info.
        /// </value>
        [XmlElementAttribute("WaitingListInfo", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "WaitingListInfo", Order = 9)]
        public string WaitingListInfo { get; set; }

        #endregion
    }
}
