﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;
using System.Collections;
using System.Collections.Generic;

namespace BMS.DataContracts
{
    /// <summary>
    /// Filtering class used to return data about bed ocuppancy based on past and current admissions assigned to that bed.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "BedOccupancyInfo")]
    [DataContract(Name = "BedOccupancyInfo")]
    [KnownType(typeof(Act))]
    [KnownType(typeof(II))]
    [KnownType(typeof(CD))]
    public class BedOccupancyInfo
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the flow id.
        /// </summary>
        /// <value>
        /// The flow id.
        /// </value>
        [XmlElementAttribute("FlowId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "FlowId", Order = 2)]
        public Guid FlowId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 3)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        /// <value>
        /// The bed id.
        /// </value>
        [XmlElementAttribute("BedId", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 4)]
        public II BedId { get; set; }

        /// <summary>
        /// Gets or sets the status of the discharge(EVS concept).
        /// </summary>
        /// <value>
        /// The discharge status.
        /// </value>
        [XmlElementAttribute("DischargeStatus", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "DischargeStatus", Order = 5)]
        public string DischargeStatus { get; set; }

        /// <summary>
        /// Gets or sets the ward id.
        /// </summary>
        /// <value>
        /// The ward id.
        /// </value>
        [XmlElementAttribute("WardId", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "WardId", Order = 6)]
        public II WardId { get; set; }

        /// <summary>
        /// Gets or sets the date and time when the patient was moved.
        /// </summary>
        /// <value>
        /// The movement date.
        /// </value>
        [XmlElementAttribute("MovementDate", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "MovementDate", Order = 7)]
        public DateTime? MovementDate { get; set; }

        /// <summary>
        /// Gets or sets the length of stay admin.
        /// </summary>
        /// <value>
        /// The length of stay admin.
        /// </value>
        [XmlElementAttribute("LosAdmin", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "LosAdmin", Order = 8)]
        public TimeSpan LosAdmin { get; set; }

        /// <summary>
        /// Gets or sets the time the patient stayed in the ward.
        /// </summary>
        /// <value>
        /// The length of stay ward.
        /// </value>
        [XmlElementAttribute("LosWard", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "LosWard", Order = 9)]
        public TimeSpan LosWard { get; set; }

        /// <summary>
        /// Gets or sets the time the patient stayed in Diagnosis Related Group.
        /// </summary>
        /// <value>
        /// The length of stay drg.
        /// </value>
        [XmlElementAttribute("LosDrg", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "LosDrg", Order = 10)]
        public TimeSpan LosDrg { get; set; }

        /// <summary>
        /// Gets or sets the bed availability status(EVS concept).
        /// </summary>
        /// <value>
        /// The bed availability status.
        /// </value>
        [XmlElementAttribute("BedAvailabilityStatus", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "BedAvailabilityStatus", Order = 11)]
        public string BedAvailabilityStatus { get; set; }

        /// <summary>
        /// Gets or sets the bed out of service reason(EVS concept).
        /// </summary>
        /// <value>
        /// The bed out of service reason.
        /// </value>
        [XmlElementAttribute("Reason", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "Reason", Order = 12)]
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets the date and time when the bed was accepted to clean.
        /// </summary>
        /// <value>
        /// The bed clean accepted date date.
        /// </value>
        [XmlElementAttribute("BedCleanAcceptedDate", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "BedCleanAcceptedDate", Order = 13)]
        public DateTime? BedCleanAcceptedDate { get; set; }

        /// <summary>
        /// Gets or sets the date and time when the bed was cleaned.
        /// </summary>
        /// <value>
        /// The movement date.
        /// </value>
        [XmlElementAttribute("BedCleanCompletedDate", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "BedCleanCompletedDate", Order = 14)]
        public DateTime? BedCleanCompletedDate { get; set; }

        /// <summary>
        /// Gets or sets if bed IS UNAVAILABLE FROM VISTA.
        /// </summary>
        /// <value>
        /// The movement date.
        /// </value>
        [XmlElementAttribute("IsUnavailableFromVista", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "IsUnavailableFromVista", Order = 15)]
        public bool? IsUnavailableFromVista { get; set; }

        /// <summary>
        /// Gets or sets if bed IS VACATED. true = vacated.
        /// </summary>
        /// <value>
        /// The movement date.
        /// </value>
        [XmlElementAttribute("IsVacated", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "IsVacated", Order = 16)]
        public bool? IsVacated { get; set; }

        /// <summary>
        /// Gets or sets the date and time when the bed clean request was made.
        /// </summary>
        /// <value>
        /// The bed clean request date date.
        /// </value>
        [XmlElementAttribute("BedCleanRequestedDate", Order = 17)]
        [DataMember(EmitDefaultValue = false, Name = "BedCleanRequestedDate", Order = 17)]
        public DateTime? BedCleanRequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the interward transfer.
        /// </summary>
        /// <value>
        /// The interward transfer.
        /// </value>
        [XmlElementAttribute("InterWardTransfer", Order = 18)]
        [DataMember(EmitDefaultValue = false, Name = "InterWardTransfer", Order = 18)]
        public int? InterWardTransfer { get; set; }

        /// <summary>
        /// Gets or sets the level of care.
        /// </summary>
        /// <value>
        /// The level of care.
        /// </value>
        [XmlElementAttribute("LevelOfCare", Order = 19)]
        [DataMember(EmitDefaultValue = false, Name = "LevelOfCare", Order = 19)]
        public string LevelOfCare { get; set; }

        /// <summary>
        /// Gets or sets the icon flag ids of bed list.
        /// </summary>
        /// <value>
        /// The icon flag ids of bed list.
        /// </value>
        [XmlElementAttribute("IconFlagIdsOfBedList", Order = 20)]
        [DataMember(EmitDefaultValue = false, Name = "IconFlagIdsOfBedList", Order = 20)]
        public List<int> IconFlagIdsOfBedList { get; set; }

        /// <summary>
        /// Gets or sets the icon flag ids of patient list.
        /// </summary>
        /// <value>
        /// The icon flag ids of patient list.
        /// </value>
        [XmlElementAttribute("IconFlagIdsOfPatientList", Order = 21)]
        [DataMember(EmitDefaultValue = false, Name = "IconFlagIdsOfPatientList", Order = 21)]
        public List<int> IconFlagIdsOfPatientList { get; set; }

        /// <summary>
        /// Gets or sets the icon flag facility ids of bed list.
        /// </summary>
        /// <value>
        /// The icon flag facility ids of bed list.
        /// </value>
        [XmlElementAttribute("IconFlagFacilityIdsOfBedList", Order = 22)]
        [DataMember(EmitDefaultValue = false, Name = "IconFlagFacilityIdsOfBedList", Order = 22)]
        public List<int> IconFlagFacilityIdsOfBedList { get; set; }

        /// <summary>
        /// Gets or sets the icon flag facility ids of patient list.
        /// </summary>
        /// <value>
        /// The icon flag facility ids of patient list.
        /// </value>
        [XmlElementAttribute("IconFlagFacilityIdsOfPatientList", Order = 23)]
        [DataMember(EmitDefaultValue = false, Name = "IconFlagFacilityIdsOfPatientList", Order = 23)]
        public List<int> IconFlagFacilityIdsOfPatientList { get; set; }

        /// <summary>
        /// Gets or sets the waiting list patient id.
        /// </summary>
        /// <value>
        /// The waiting list patient id.
        /// </value>
        [XmlElementAttribute("WaitingListPatientId", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "WaitingListPatientId", Order = 24)]
        public II WaitingListPatientId { get; set; }

        /// <summary>
        /// Gets or sets the waiting list info.
        /// </summary>
        /// <value>
        /// The waiting list info.
        /// </value>
        [XmlElementAttribute("WaitingListInfo", Order = 24)]
        [DataMember(EmitDefaultValue = false, Name = "WaitingListInfo", Order = 25)]
        public string WaitingListInfo { get; set; }

        /// <summary>
        /// Gets or sets the level of care date.
        /// </summary>
        /// <value>
        /// The level of care date.
        /// </value>
        [XmlElementAttribute("LevelOfCareDate", Order = 26)]
        [DataMember(EmitDefaultValue = false, Name = "LevelOfCareDate", Order = 26)]
        public DateTime? LevelOfCareDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is evacuation patient.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is evacuation patient; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsEvacuationPatient", Order = 27)]
        [DataMember(EmitDefaultValue = false, Name = "IsEvacuationPatient", Order = 27)]
        public bool IsEvacuationPatient { get; set; }

        /// <summary>
        /// Gets or sets the evacuation disposition status.
        /// </summary>
        /// <value>
        /// The evacuation disposition status.
        /// </value>
        [XmlElementAttribute("EvacuationDispositionStatus", Order = 28)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationDispositionStatus", Order = 28)]
        public string EvacuationDispositionStatus { get; set; }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        /// <value>
        /// The admission date.
        /// </value>
        [XmlElementAttribute("AdmissionDate", Order = 29)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionDate", Order = 29)]
        public DateTime? AdmissionDate { get; set; }

        #endregion
    }
}
