﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about bed clening operations (manual bed cleaning within BMS).
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "BedClean")]
    [DataContract(Name = "BedClean")]
    [KnownType(typeof(II))]
    [KnownType(typeof(CD))]
    public class BedCleaningOperation
    {
        #region Public Members
        /// <summary>
        /// Gets or sets the bed which needs to be cleaned(EIS place reference).
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        [XmlElementAttribute("BedId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 1)]
        public II BedId { get; set; }

        /// <summary>
        /// Gets or sets the ward list.
        /// </summary>
        /// <value>
        /// The ward list.
        /// </value>
        [XmlElementAttribute("WardId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "WardId", Order = 2)]
        public II WardId { get; set; }

        /// <summary>
        /// Gets or sets the status of the bed cleaning(EVS concept).
        /// </summary>
        /// <value>
        /// The type of clean.
        /// </value>
        [XmlElementAttribute("TypeOfClean", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "TypeOfClean", Order = 3)]
        public CD TypeOfClean { get; set; }

        /// <summary>
        /// Gets or sets whether the cleaning request is manual or automatic.
        /// </summary>
        /// <value>
        /// The manual request.
        /// </value>
        [XmlElementAttribute("ManualRequest", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "ManualRequest", Order = 4)]
        public CD ManualRequest { get; set; }

        /// <summary>
        /// Gets or sets the date when the bed cleaning event was accepted by someone form the EMS staff.
        /// </summary>
        /// <value>
        /// The accepted date.
        /// </value>
        [XmlElementAttribute("AcceptedDate", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "AcceptedDate", Order = 5)]
        public DateTime? AcceptedDate { get; set; }

        /// <summary>
        /// Gets or sets the date when the bed cleaning event was completed by someone form the EMS staff.
        /// </summary>
        /// <value>
        /// The completed date.
        /// </value>
        [XmlElementAttribute("CompletedDate", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "CompletedDate", Order = 6)]
        public DateTime? CompletedDate { get; set; }

        /// <summary>
        /// Gets or sets the person from the EMS staff that accepted the bed cleaning event.
        /// </summary>
        /// <value>
        /// The accepted by.
        /// </value>
        [XmlElementAttribute("AcceptedBy", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "AcceptedBy", Order = 7)]
        public string AcceptedBy { get; set; }

        /// <summary>
        /// Gets or sets the person from the EMS staff that completed the bed cleaning event.
        /// </summary>
        /// <value>
        /// The accepted by.
        /// </value>
        [XmlElementAttribute("CompletedBy", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "CompletedBy", Order = 8)]
        public string CompletedBy { get; set; }

        /// <summary>
        /// Gets or sets the person from the EMS staff that last edited the bed cleaning event.
        /// </summary>
        /// <value>
        /// The last edited by.
        /// </value>
        [XmlElementAttribute("LastEditedBy", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditedBy", Order = 9)]
        public string LastEditedBy { get; set; }

        /// <summary>
        /// Gets or sets the last edit date when the bed cleaning event was completed by someone form the EMS staff.
        /// </summary>
        /// <value>
        /// The last edit date.
        /// </value>
        [XmlElementAttribute("LastEditDate", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditDate", Order = 10)]
        public DateTime? LastEditDate { get; set; }

        /// <summary>
        /// Gets or sets the date when the bed cleaning event was requested.
        /// </summary>
        /// <value>
        /// The requested date.
        /// </value>
        [XmlElementAttribute("RequestedDate", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "RequestedDate", Order = 11)]
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the vista site where the bed is placed.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 12)]
        public II VistaSiteId { get; set; }

        /// <summary>
        /// Gets or sets the division.
        /// </summary>
        /// <value>
        /// The division.
        /// </value>
        [XmlElementAttribute("DivisionId", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "DivisionId", Order = 13)]
        public II DivisionId { get; set; }

        /// <summary>
        /// Gets or sets EMS Notify flag.
        /// </summary>
        /// <value>
        /// The EMS notified flag.
        /// </value>
        [XmlElementAttribute("EMSNotify", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "EMSNotify", Order = 14)]
        public string EMSNotify { get; set; }

        /// <summary>
        /// Gets or sets the special instructions.
        /// </summary>
        /// <value>
        /// The special instructions.
        /// </value>
        [XmlElementAttribute("SpecialInstructions", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "SpecialInstructions", Order = 15)]
        public string SpecialInstructions { get; set; }

        /// <summary>
        /// Gets or sets the bed cleaning comment.
        /// </summary>
        /// <value>
        /// The bed cleaning comment.
        /// </value>
        [XmlElementAttribute("Comment", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "Comment", Order = 16)]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the user name who added a comment.
        /// </summary>
        /// <value>
        /// The user name who added a comment.
        /// </value>
        [XmlElementAttribute("CommentedBy", Order = 17)]
        [DataMember(EmitDefaultValue = false, Name = "CommentedBy", Order = 17)]
        public string CommentedBy { get; set; }

        /// <summary>
        /// Gets or sets the date when the comment was added.
        /// </summary>
        /// <value>
        /// The date when the comment was added.
        /// </value>
        [XmlElementAttribute("CommentedDate", Order = 18)]
        [DataMember(EmitDefaultValue = false, Name = "CommentedDate", Order = 18)]
        public DateTime? CommentedDate { get; set; }

        /// <summary>
        /// Gets or sets the vacated date.
        /// </summary>
        /// <value>
        /// The vacated date.
        /// </value>
        [XmlElementAttribute("VacatedDate", Order = 19)]
        [DataMember(EmitDefaultValue = false, Name = "VacatedDate", Order = 19)]
        public DateTime? VacatedDate { get; set; }

        /// <summary>
        /// Gets or sets the type of the event(ADM, TRA, DIS, BSW).
        /// </summary>
        /// <value>
        /// The type of the event.
        /// </value>
        [XmlElementAttribute("EventType", Order = 20)]
        [DataMember(EmitDefaultValue = false, Name = "EventType", Order = 20)]
        public string EventType { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 21)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 21)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the event ien.
        /// </summary>
        /// <value>
        /// The event ien.
        /// </value>
        [XmlElementAttribute("EventIen", Order = 22)]
        [DataMember(EmitDefaultValue = false, Name = "EventIen", Order = 22)]
        public string EventIen { get; set; }

        #endregion
    }
}
