﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;
using BMS.Translators;

namespace BMS.Translators
{
    /// <summary>
    /// Translator class for patient waiting date view entity
    /// </summary>
    public static class TranslatorPatientWaitingDateView
    {
        public static void CopyTo(this PatientWaitingDateViewBO patientWaitingBO, DataContracts.PatientWaitingDateView patientWaiting)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                patientWaiting.CanceledDate = patientWaitingBO.CANCELED_DATE.Value;
                patientWaiting.CreationDate = patientWaitingBO.CREATION_DATE.Value;
                patientWaiting.PatientId = TranslatorUtils.BuildIdentifier(patientWaitingBO.DOMAIN_ID, patientWaitingBO.PATIENT_UID);
                patientWaiting.AdmissionFacilityId = TranslatorUtils.BuildIdentifier(patientWaitingBO.DOMAIN_ID, patientWaitingBO.EVN_ADMISSION_FACILITY_UID);
                patientWaiting.FacilityId = TranslatorUtils.BuildIdentifier(patientWaitingBO.DOMAIN_ID, patientWaitingBO.REQ_FACILITY_UID);
                patientWaiting.Specialty = patientWaitingBO.REQ_SPECIALITY_DISPLAY_NAME.Value;
                patientWaiting.DispositionDate = patientWaitingBO.EVN_DISPOSITION_DATE.Value;
                patientWaiting.EventDate = patientWaitingBO.EVN_EVENT_DATE.Value;
                patientWaiting.RegionCode = patientWaitingBO.REGION_CODE.Value;
                patientWaiting.VISNCode = patientWaitingBO.VISN_CODE.Value;
                patientWaiting.EntryBy = patientWaitingBO.ENTER_BY.Value;
                patientWaiting.LastEditBy = patientWaitingBO.LAST_EDIT_BY.Value;
                patientWaiting.LastEditDate = patientWaitingBO.LAST_EDIT_DATE.Value;
                patientWaiting.IsNationalWaitList = patientWaitingBO.IS_NATIONAL_WAIT_LIST.Value == true ? true : false;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
