﻿using BMS.MT;
using System;
using BMS.Utils;
using System.Collections.Generic;
using BMS.DataContracts;
using System.Linq;
using ePractice.MiddleTier;

namespace BMS.Translators
{
    public static class TranslatorBedOccupancyInfo
    {
        public static void CopyTo(this IEntityCollection bedOccupancyInfoBOList, List<DataContracts.BedOccupancyInfo> bedOccupancyInfoList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DataContracts.BedOccupancyInfo bedOccupancyInfo = null;
                foreach (BedOccupancyInfoBO bedOccupancyInfoBO in bedOccupancyInfoBOList)
                {
                    bedOccupancyInfo = new DataContracts.BedOccupancyInfo();
                    bedOccupancyInfo.Id = TranslatorUtils.BuildIdentifier(bedOccupancyInfoBO.DOMAIN_ID, bedOccupancyInfoBO.ACT_ID);
                    bedOccupancyInfo.PatientId = TranslatorUtils.BuildIdentifier(bedOccupancyInfoBO.DOMAIN_ID, bedOccupancyInfoBO.PATIENT_UID);
                    bedOccupancyInfo.FlowId = bedOccupancyInfoBO.FLOW_ID.Value;
                    bedOccupancyInfo.BedId = TranslatorUtils.BuildIdentifier(bedOccupancyInfoBO.DOMAIN_ID, bedOccupancyInfoBO.EVN_BED_UID);
                    bedOccupancyInfo.WardId = TranslatorUtils.BuildIdentifier(bedOccupancyInfoBO.DOMAIN_ID, bedOccupancyInfoBO.EVN_WARD_UID);
                    bedOccupancyInfo.DischargeStatus = bedOccupancyInfoBO.DISCHARGE_ORDER_TEXT.Value;
                    bedOccupancyInfo.BedAvailabilityStatus = bedOccupancyInfoBO.BED_AVAILABILITY_STATUS.Value;
                    bedOccupancyInfo.MovementDate = bedOccupancyInfoBO.MOVEMENT_DATE.Value;
                    bedOccupancyInfo.Reason = bedOccupancyInfoBO.REASON.Value;
                    bedOccupancyInfo.AdmissionDate = bedOccupancyInfoBO.ADMISSION_DATE.Value;
                    if (bedOccupancyInfoBO.MOVEMENT_DATE.Value.HasValue)
                        bedOccupancyInfo.LosWard = DateTime.UtcNow - bedOccupancyInfoBO.MOVEMENT_DATE.Value.Value;
                    if (bedOccupancyInfoBO.ADMISSION_DATE.Value.HasValue)
                        bedOccupancyInfo.LosAdmin = DateTime.UtcNow - bedOccupancyInfoBO.ADMISSION_DATE.Value.Value;
                    bedOccupancyInfo.LosDrg = new TimeSpan();
                    bedOccupancyInfo.BedCleanRequestedDate = bedOccupancyInfoBO.BED_CLEAN_REQUESTED_DATE.Value;
                    bedOccupancyInfo.BedCleanCompletedDate = bedOccupancyInfoBO.BED_CLEAN_COMPLETED_DATE.Value;
                    bedOccupancyInfo.BedCleanAcceptedDate = bedOccupancyInfoBO.BED_CLEAN_ACCEPTED_DATE.Value;
                    bedOccupancyInfo.IsUnavailableFromVista = bedOccupancyInfoBO.IS_UNAVAILABLE_FROM_VISTA.Value;
                    bedOccupancyInfo.IsVacated = bedOccupancyInfoBO.IS_VACATED.Value;
                    bedOccupancyInfo.InterWardTransfer = bedOccupancyInfoBO.INTERWARD_TRANSFER.Value;
                    if (string.IsNullOrEmpty(bedOccupancyInfoBO.ICON_FLAG_IDS_OF_BED.Value))
                        bedOccupancyInfo.IconFlagIdsOfBedList = new List<int>();
                    else
                        bedOccupancyInfo.IconFlagIdsOfBedList = bedOccupancyInfoBO.ICON_FLAG_IDS_OF_BED.Value.Split(',').Select(n => int.Parse(n)).ToList();

                    if (string.IsNullOrEmpty(bedOccupancyInfoBO.ICON_FLAG_IDS_OF_PATIENT.Value))
                        bedOccupancyInfo.IconFlagIdsOfPatientList = new List<int>();
                    else
                        bedOccupancyInfo.IconFlagIdsOfPatientList = bedOccupancyInfoBO.ICON_FLAG_IDS_OF_PATIENT.Value.Split(',').Select(n => int.Parse(n)).ToList();

                    if (string.IsNullOrEmpty(bedOccupancyInfoBO.ICON_FLAG_FACILITY_IDS_OF_BED.Value))
                        bedOccupancyInfo.IconFlagFacilityIdsOfBedList = new List<int>();
                    else
                        bedOccupancyInfo.IconFlagFacilityIdsOfBedList = bedOccupancyInfoBO.ICON_FLAG_FACILITY_IDS_OF_BED.Value.Split(',').Select(n => int.Parse(n)).ToList();

                    if (string.IsNullOrEmpty(bedOccupancyInfoBO.ICON_FLAG_FACILITY_IDS_OF_PATIENT.Value))
                        bedOccupancyInfo.IconFlagFacilityIdsOfPatientList = new List<int>();
                    else
                        bedOccupancyInfo.IconFlagFacilityIdsOfPatientList = bedOccupancyInfoBO.ICON_FLAG_FACILITY_IDS_OF_PATIENT.Value.Split(',').Select(n => int.Parse(n)).ToList();

                    if (bedOccupancyInfoBO.WAITING_LIST_PATIENT_UID != null)
                        bedOccupancyInfo.WaitingListPatientId = TranslatorUtils.BuildIdentifier(bedOccupancyInfoBO.DOMAIN_ID, bedOccupancyInfoBO.WAITING_LIST_PATIENT_UID);
                    else
                        bedOccupancyInfo.WaitingListPatientId = null;
                    bedOccupancyInfo.WaitingListInfo = bedOccupancyInfoBO.WAITING_LIST_INFO.Value;
                    bedOccupancyInfo.LevelOfCareDate = bedOccupancyInfoBO.LEVEL_OF_CARE_DATE.Value;
                    bedOccupancyInfo.IsEvacuationPatient = bedOccupancyInfoBO.IS_EVACUATION_PATIENT.Value;
                    bedOccupancyInfo.EvacuationDispositionStatus = bedOccupancyInfoBO.EVACUATION_DISPOSITION_STATUS.Value;
                    bedOccupancyInfo.LevelOfCare = bedOccupancyInfoBO.LEVEL_OF_CARE.Value;

                    bedOccupancyInfoList.Add(bedOccupancyInfo);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
