﻿using InfoWorld.HL7.ITS;
using BMS.ServiceContracts;
using System.ServiceModel;
using BMS.MT;
using System;
using ePractice.MiddleTier;
using BMS.Translators;
using BMS.Utils;
using System.Transactions;
using BMS.ServiceImplementation.Properties;
using BMS.FaultContracts;
using BMS.ServiceImplementation.Utils;
using System.Collections.Generic;
using System.Linq;
using BMS.DataContracts;
using System.Text;

namespace BMS.ServiceImplementation
{
    [ErrorHandlerAttribute]
    [ServiceBehavior(IgnoreExtensionDataObject = true, InstanceContextMode = InstanceContextMode.PerSession, ConcurrencyMode = ConcurrencyMode.Multiple, IncludeExceptionDetailInFaults = true, UseSynchronizationContext = false)]
    public class BedManagerOperationsCore : IBedManagerOperations
    {
        private static object _lockMovementEvents = new object();
        private static object _lockBedUnavailable = new object();

        #region Admission

        public II CreateAdmissionOrder(DataContracts.AdmissionOrder admissionOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (admissionOrder == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "admissionOrder", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NULL_PARAMETER });

                AdmissionOrderBO bo = (AdmissionOrderBO)MTServices.Instance[Resources.MT_AdmissionOrder].CreateNew();
                admissionOrder.CopyTo(bo);
                bo.Save();
                II id = TranslatorUtils.BuildIdentifier(bo.DOMAIN_ID, bo.ID);
                bo = null;

                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.AdmissionOrder GetAdmissionOrder(II admissionOrderId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (admissionOrderId == null || string.IsNullOrEmpty(admissionOrderId.root) || string.IsNullOrEmpty(admissionOrderId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "admissionOrderId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NULL_PARAMETER });
                DataContracts.AdmissionOrder result = new DataContracts.AdmissionOrder();
                GetAdmissionOrderById(admissionOrderId).CopyTo(result);
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateAdmissionOrder(DataContracts.AdmissionOrder admissionOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (admissionOrder == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "admissionOrder", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NULL_PARAMETER });

                AdmissionOrderBO bo = GetAdmissionOrderById(admissionOrder.Id);
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NOT_FOUND });
                admissionOrder.OrderedDate = bo.ORDERED_DATE.Value;
                admissionOrder.CopyTo(bo);
                bo.Save();
                bo = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateAdmissionEvent(DataContracts.AdmissionEvent admissionEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (admissionEvent == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "admissionEvent", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_ADMISSION_EVENT_NULL_PARAMETER });

                AdmissionEvnBO bo = (AdmissionEvnBO)MTServices.Instance[Resources.MT_AdmissionEvent].CreateNew();
                admissionEvent.CopyTo(bo);
                bo.Save();
                II id = TranslatorUtils.BuildIdentifier(bo.DOMAIN_ID, bo.ID);
                bo = null;
                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.AdmissionEvent GetAdmissionEvent(II admissionEventId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (admissionEventId == null || string.IsNullOrEmpty(admissionEventId.root) || string.IsNullOrEmpty(admissionEventId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "admissionEventId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_ADMISSION_EVENT_NULL_PARAMETER });
                DataContracts.AdmissionEvent result = new DataContracts.AdmissionEvent();
                GetAdmissionEventById(admissionEventId).CopyTo(result);
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.AdmissionEvent GetAdmissionEventForPatient(II patientId, II vistaId, string eventIen, DateTime? eventDateTime)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DataContracts.AdmissionEvent result = new DataContracts.AdmissionEvent();
                AdmissionEventParPO parameters = (AdmissionEventParPO)MTServices.Instance[Resources.MT_AdmissionEvent].Parameters;
                parameters.DOMAIN_ID.Value = vistaId.root;
                parameters.ID.Value = null;
                parameters.PATIENT_UID.Value = patientId != null ? Guid.Parse(patientId.extension) : (Guid?)null;
                parameters.VISTA_SITE_UID.Value = Guid.Parse(vistaId.extension);
                parameters.EVENT_IEN.Value = eventIen;
                parameters.EVENT_DATE_TIME.Value = eventDateTime;

                AdmissionEvnBO bo = MTServices.Instance[Resources.MT_AdmissionEvent].GetEntityFull(parameters) as AdmissionEvnBO;
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_ADMISSION_EVENT_NOT_FOUND });
                bo.CopyTo(result);
                bo = null;
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateAdmissionEvent(DataContracts.AdmissionEvent admissionEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (admissionEvent == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "admissionEvent", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ADMISSION_EVENT_NULL_PARAMETER });

                AdmissionEvnBO bo = GetAdmissionEventById(admissionEvent.Id);
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ADMISSION_EVENT_NOT_FOUND });
                admissionEvent.EnteredDate = bo.ENTERED_DATE.Value;
                admissionEvent.CopyTo(bo);
                bo.Save();
                bo = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Transfer

        public II CreateTransfer(DataContracts.Transfer transfer)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (transfer == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "transfer", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_TRANSFER_NULL_PARAMETER });

                return NewTransfer(transfer);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public DataContracts.Transfer GetTransfer(II transferId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (transferId == null || string.IsNullOrEmpty(transferId.root) || string.IsNullOrEmpty(transferId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "transferId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_TRANSFER_NULL_PARAMETER });

                DataContracts.Transfer transfer = new DataContracts.Transfer();
                GetTransferById(transferId).CopyTo(transfer);
                return transfer;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateTransfer(DataContracts.Transfer transfer)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (transfer == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "transfer", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_TRANSFER_NULL_PARAMETER });

                ModifyTransfer(transfer);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Discharge

        public II CreateDischargeAppointment(DataContracts.DischargeAppointment dischargeAppointment)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (dischargeAppointment == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "dischargeAppointment", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_DISCHARGE_APPOINTMENT_NULL_PARAMETER });

                DischargeIntBO bo = (DischargeIntBO)MTServices.Instance[Resources.MT_DischargeAppointment].CreateNew();
                dischargeAppointment.CopyTo(bo);
                bo.Save();
                II id = TranslatorUtils.BuildIdentifier(bo.DOMAIN_ID, bo.ID);
                bo = null;
                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.DischargeAppointment GetDischargeAppointment(II dischargeAppointmentId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (dischargeAppointmentId == null || string.IsNullOrEmpty(dischargeAppointmentId.root) || string.IsNullOrEmpty(dischargeAppointmentId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "dischargeAppointmentId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_DISCHARGE_APPOINTMENT_NULL_PARAMETER });
                DataContracts.DischargeAppointment result = new DataContracts.DischargeAppointment();
                GetDischargeAppointmentById(dischargeAppointmentId).CopyTo(result);
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateDischargeAppointment(DataContracts.DischargeAppointment dischargeAppointment)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (dischargeAppointment == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "dischargeAppointment", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_DISCHARGE_APPOINTMENT_NULL_PARAMETER });

                DischargeIntBO bo = GetDischargeAppointmentById(dischargeAppointment.Id);
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_DISCHARGE_APPOINTMENT_NOT_FOUND });
                dischargeAppointment.EnteredDate = bo.DATE_ENTERED.Value;
                dischargeAppointment.CopyTo(bo);
                bo.Save();
                bo = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.DischargeAppointment GetDischargeIntent(DateTime appointmentDateTime, II vistaId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DataContracts.DischargeAppointment discharge = new DataContracts.DischargeAppointment();

                DischargeAppointmentParPO parameters = (DischargeAppointmentParPO)MTServices.Instance[Resources.MT_DischargeAppointment].Parameters;
                parameters.DOMAIN_ID.Value = vistaId.root;
                parameters.APPOINTMENT_DATE.Value = appointmentDateTime;
                parameters.VISTA_SITE_UID.Value = Guid.Parse(vistaId.extension);

                DischargeIntBO dischargeBO = MTServices.Instance[Resources.MT_DischargeAppointment].GetEntityFull(parameters) as DischargeIntBO;
                if (dischargeBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_DISCHARGE_APPOINTMENT_NOT_FOUND });
                dischargeBO.CopyTo(discharge);
                return discharge;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateDischargeOrder(DataContracts.DischargeOrder dischargeOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (dischargeOrder == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "dischargeOrder", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_DISCHARGE_ORDER_NULL_PARAMETER });

                DischargeReqBO bo = (DischargeReqBO)MTServices.Instance[Resources.MT_DischargeOrder].CreateNew();
                dischargeOrder.CopyTo(bo);
                bo.Save();
                II id = TranslatorUtils.BuildIdentifier(bo.DOMAIN_ID, bo.ID);
                bo = null;

                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.DischargeOrder GetDischargeOrder(II dischargeOrderId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (dischargeOrderId == null || string.IsNullOrEmpty(dischargeOrderId.root) || string.IsNullOrEmpty(dischargeOrderId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "dischargeOrderId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_DISCHARGE_ORDER_NULL_PARAMETER });
                DataContracts.DischargeOrder result = new DataContracts.DischargeOrder();
                GetDischargeOrderById(dischargeOrderId).CopyTo(result);
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateDischargeOrder(DataContracts.DischargeOrder dischargeOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (dischargeOrder == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "dischargeOrder", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_DISCHARGE_ORDER_NULL_PARAMETER });

                DischargeReqBO bo = GetDischargeOrderById(dischargeOrder.Id);
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_DISCHARGE_ORDER_NOT_FOUND });
                dischargeOrder.OrderedDate = bo.ORDERED_DATE.Value;
                dischargeOrder.CopyTo(bo);
                bo.Save();
                bo = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateDischargeEvent(DataContracts.DischargeEvent dischargeEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {                
                if (dischargeEvent == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "dischargeEvent", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_DISCHARGE_EVENT_NULL_PARAMETER });

                DischargeEvnBO bo = (DischargeEvnBO)MTServices.Instance[Resources.MT_DischargeEvent].CreateNew();
                dischargeEvent.CopyTo(bo);
                //lock (_lockMovementEvents)               
                int retry = 0;
                while (retry < 3)
                {
                    try
                    {
                        bo.Save();
                        retry = 3;
                    }
                    catch (System.Data.SqlClient.SqlException sqlEx)
                    {
                        if (sqlEx.Number == 1205) //Deadlock
                        {
                            if (retry == 2)
                            {
                                Tracer.TraceException(sqlEx);
                                throw sqlEx;
                            }
                            else
                            {
                                retry++;
                                Tracer.TraceMessage("BMSService CreateDischargeEvent deadlock. Retry: " + retry.ToString());
                            }
                        }
                        else
                        {
                            retry = 3;
                            Tracer.TraceException(sqlEx);
                            throw sqlEx;
                        }
                    }
                    catch (Exception ex)
                    {
                        retry = 3;
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
                II id = TranslatorUtils.BuildIdentifier(bo.DOMAIN_ID, bo.ID);
                bo = null;
                return id;                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.DischargeEvent GetDischargeEvent(II dischargeEventId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (dischargeEventId == null || string.IsNullOrEmpty(dischargeEventId.root) || string.IsNullOrEmpty(dischargeEventId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "dischargeEventId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_DISCHARGE_EVENT_NULL_PARAMETER });
                DataContracts.DischargeEvent result = new DataContracts.DischargeEvent();
                GetDischargeEventById(dischargeEventId).CopyTo(result);
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateDischargeEvent(DataContracts.DischargeEvent dischargeEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (dischargeEvent == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "dischargeEvent", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_DISCHARGE_EVENT_NULL_PARAMETER });

                DischargeEvnBO bo = GetDischargeEventById(dischargeEvent.Id);
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_DISCHARGE_EVENT_NOT_FOUND });
                dischargeEvent.EnteredDate = bo.ENTERED_DATE.Value;
                dischargeEvent.CopyTo(bo);
                bo.Save();
                bo = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Bed Clean

        public II CreateBedCleaningOperation(DataContracts.BedCleaningOperation bedCleaningOperation)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (bedCleaningOperation == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedCleaningOperation", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_BED_CLEANING_NULL_PARAMETER });

                return NewBedCleaning(bedCleaningOperation);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.BedCleaningOperation GetBedCleaningOperation(II bedCleaningOperationId, II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if ((bedCleaningOperationId == null || string.IsNullOrEmpty(bedCleaningOperationId.root) || string.IsNullOrEmpty(bedCleaningOperationId.extension))
                    && (bedId == null || string.IsNullOrEmpty(bedId.root) || string.IsNullOrEmpty(bedId.extension)))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedCleaningOperationId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_BED_CLEANING_NULL_PARAMETER });

                DataContracts.BedCleaningOperation bedCleaning = new DataContracts.BedCleaningOperation();
                GetBedCleaningById(bedCleaningOperationId, bedId).CopyTo(bedCleaning);
                return bedCleaning;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateBedCleaningOperation(DataContracts.BedCleaningOperation bedCleaningOperation)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (bedCleaningOperation == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedCleaningOperation", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_BED_CLEANING_NULL_PARAMETER });

                ModifyBedCleaning(bedCleaningOperation);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Bed Unavailable

        public II CreateBedUnavailable(DataContracts.BedUnavailable bedUnavailable)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (bedUnavailable == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedUnavailable", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_BED_UNAVAILABLE_NULL_PARAMETER });

                lock (_lockBedUnavailable)
                {                    
                    return NewBedUnavailable(bedUnavailable);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.BedUnavailable GetBedUnavailable(II bedUnavailableId, II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if ((bedUnavailableId == null || string.IsNullOrEmpty(bedUnavailableId.root) || string.IsNullOrEmpty(bedUnavailableId.extension))
                    && (bedId == null || string.IsNullOrEmpty(bedId.root) || string.IsNullOrEmpty(bedId.extension)))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedUnavailableId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_BED_UNAVAILABLE_NULL_PARAMETER });

                DataContracts.BedUnavailable bedUnavailable = new DataContracts.BedUnavailable();
                GetBedUnavailableById(bedUnavailableId, bedId).CopyTo(bedUnavailable);
                return bedUnavailable;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateBedUnavailable(DataContracts.BedUnavailable bedUnavailable)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (bedUnavailable == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedUnavailable", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_BED_UNAVAILABLE_NULL_PARAMETER });

                ModifyBedUnavailable(bedUnavailable);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Bed Unavailable History

        public void InsertBedUnavailableHistory(DataContracts.BedUnavailableHistory bedUnavailableHistory)
        {
            if (bedUnavailableHistory == null)
                throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedUnavailableHistory", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_BED_UNAVAILABLE_NULL_PARAMETER });

            NewBedUnvailableHistory(bedUnavailableHistory);
        }

        #endregion

        #region Diversion

        public II CreateDiversion(DataContracts.Diversion diversion)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (diversion == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "diversion", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_DIVERSION_NULL_PARAMETER });

                return NewDiversion(diversion);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.Diversion GetDiversion(II diversionId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (diversionId == null || string.IsNullOrEmpty(diversionId.root) || string.IsNullOrEmpty(diversionId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "diversionId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_DIVERSION_NULL_PARAMETER });

                DataContracts.Diversion diversion = new DataContracts.Diversion();
                GetDiversionById(diversionId).CopyTo(diversion);
                return diversion;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<DataContracts.Diversion> GetAllDiversion(II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.Diversion> listDiversions = new List<DataContracts.Diversion>();
                DataContracts.Diversion diversion = null;
                List<DiversionBO> listDiversionBO = GetDiversions(facilityId);
                if (listDiversionBO != null)
                {
                    foreach (DiversionBO diversionBO in listDiversionBO)
                    {
                        diversion = new DataContracts.Diversion();
                        diversionBO.CopyTo(diversion);
                        listDiversions.Add(diversion);
                    }
                }

                return listDiversions;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateDiversion(DataContracts.Diversion diversion)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (diversion == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "diversion", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_DIVERSION_NULL_PARAMETER });

                ModifyDiversion(diversion);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Movement

        public II CreateMovementOrder(DataContracts.MovementOrder movementOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (movementOrder == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "movementOrder", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_MOVEMENT_ORDER_NULL_PARAMETER });

                MovementReqBO bo = (MovementReqBO)MTServices.Instance[Resources.MT_MovementOrder].CreateNew();
                movementOrder.CopyTo(bo);
                bo.Save();
                II id = TranslatorUtils.BuildIdentifier(bo.DOMAIN_ID, bo.ID);
                bo = null;

                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.MovementOrder GetMovementOrder(II movementOrderId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (movementOrderId == null || string.IsNullOrEmpty(movementOrderId.root) || string.IsNullOrEmpty(movementOrderId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "movementOrderId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_MOVEMENT_ORDER_NULL_PARAMETER });
                DataContracts.MovementOrder result = new DataContracts.MovementOrder();
                GetMovementOrderById(movementOrderId).CopyTo(result);
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateMovementOrder(DataContracts.MovementOrder movementOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (movementOrder == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "movementOrder", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_MOVEMENT_ORDER_NULL_PARAMETER });

                MovementReqBO bo = GetMovementOrderById(movementOrder.Id);
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_MOVEMENT_ORDER_NOT_FOUND });
                movementOrder.OrderedDate = bo.ORDERED_DATE.Value;
                movementOrder.CopyTo(bo);
                bo.Save();
                bo = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateMovementEvent(DataContracts.MovementEvent movementEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {                
                if (movementEvent == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "movementEvent", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_MOVEMENT_EVENT_NULL_PARAMETER });

                MovementEvnBO bo = (MovementEvnBO)MTServices.Instance[Resources.MT_MovementEvent].CreateNew();
                movementEvent.CopyTo(bo);
                //lock (_lockMovementEvents)               
                int retry = 0;
                while (retry < 3)
                {
                    try
                    {
                        bo.Save();
                        retry = 3;
                    }
                    catch (System.Data.SqlClient.SqlException sqlEx)
                    {
                        if (sqlEx.Number == 1205) //Deadlock
                        {
                            if (retry == 2)
                            {
                                Tracer.TraceException(sqlEx);
                                throw sqlEx;
                            }
                            else
                            {
                                retry++;
                                Tracer.TraceMessage("BMSService CreateMovementEvent deadlock. Retry: " + retry.ToString());
                            }
                        }
                        else
                        {
                            retry = 3;
                            Tracer.TraceException(sqlEx);
                            throw sqlEx;
                        }
                    }
                    catch (Exception ex)
                    {
                        retry = 3;
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
                II id = TranslatorUtils.BuildIdentifier(bo.DOMAIN_ID, bo.ID);
                bo = null;
                return id;                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.MovementEvent GetMovementEvent(II movementEventId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (movementEventId == null || string.IsNullOrEmpty(movementEventId.root) || string.IsNullOrEmpty(movementEventId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "movementEventId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_MOVEMENT_EVENT_NULL_PARAMETER });
                DataContracts.MovementEvent result = new DataContracts.MovementEvent();
                GetMovementEventById(movementEventId).CopyTo(result);
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateMovementEvent(DataContracts.MovementEvent movementEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (movementEvent == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "movementEvent", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_MOVEMENT_EVENT_NULL_PARAMETER });

                MovementEvnBO bo = GetMovementEventById(movementEvent.Id);
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_MOVEMENT_EVENT_NOT_FOUND });
                movementEvent.EnteredDate = bo.ENTERED_DATE.Value;
                movementEvent.CopyTo(bo);
                bo.Save();
                bo = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Waiting List

        public II CreateWaitingListItem(DataContracts.WaitingListItem waitingListItem)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (waitingListItem == null)
                    throw new FaultException<NullParameterException>(new NullParameterException()
                    {
                        ParameterName = "waitingListItem",
                        MethodType = MethodType.Create,
                        ErrorMessage = Resources.ERR_WAITING_LIST_NULL_PARAMETER
                    });

                return NewWaitingListItem(waitingListItem);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.WaitingListItem GetWaitingListItem(II waitingListItemId, string patientUid)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if ((waitingListItemId == null || string.IsNullOrEmpty(waitingListItemId.root) || string.IsNullOrEmpty(waitingListItemId.extension)) && string.IsNullOrEmpty(patientUid))
                    throw new FaultException<NullParameterException>(new NullParameterException()
                    {
                        ParameterName = "waitingListItemId",
                        MethodType = MethodType.Read,
                        ErrorMessage = Resources.ERR_WAITING_LIST_NULL_PARAMETER
                    });

                DataContracts.WaitingListItem waitingListItem = new DataContracts.WaitingListItem();
                GetWaitingListItemById(waitingListItemId, patientUid).CopyTo(waitingListItem);
                return waitingListItem;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateWaitingListItem(DataContracts.WaitingListItem waitingListItem)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (waitingListItem == null)
                    throw new FaultException<NullParameterException>(new NullParameterException()
                    {
                        ParameterName = "waitingListItem",
                        MethodType = MethodType.Update,
                        ErrorMessage = Resources.ERR_WAITING_LIST_NULL_PARAMETER
                    });

                ModifyWaitingListItem(waitingListItem);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region IconDetail

        public int CreateIconDetail(DataContracts.IconDetail iconDetail)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (iconDetail == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "iconDetail", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_ICON_DETAIL_NULL_PARAMETER });

                return NewIconDetail(iconDetail);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.IconDetail GetIconDetail(int iconDetailId, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (iconDetailId <= 0)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "iconDetailId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_ICON_DETAIL_NULL_PARAMETER });

                DataContracts.IconDetail iconDetail = new DataContracts.IconDetail();
                GetIconDetailById(iconDetailId, facilityId).CopyTo(iconDetail);
                return iconDetail;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateIconDetail(DataContracts.IconDetail iconDetail)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (iconDetail == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "iconDetail", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ICON_DETAIL_NULL_PARAMETER });

                ModifyIconDetail(iconDetail);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteIconDetail(int iconDetailId, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (iconDetailId <= 0)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "iconDetailId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_ICON_DETAIL_NULL_PARAMETER });

                RemoveIconDetail(iconDetailId, facilityId);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void SwitchIconOrder(DataContracts.IconInfo icon1, DataContracts.IconInfo icon2)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (icon1 == null || icon2 == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "icon1", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ICON_DETAIL_NULL_PARAMETER });

                SwitchIconOrderIndexes(icon1, icon2);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region IconAssociation

        public void InsertIconAssociation(DataContracts.IconAssociation iconAssociation)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (iconAssociation == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "iconAssociation", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ICON_ASSOCIATION_NULL_PARAMETER1 });

                InsertIconDetail(iconAssociation);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        #endregion

        #region IconOrder

        public void UpdateIconOrderBulk(List<DataContracts.IconOrder> iconOrderList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (iconOrderList == null || iconOrderList.Count == 0)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "iconOrderList", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ICON_DETAIL_NULL_PARAMETER });

                ModifyIconOrderBulk(iconOrderList);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Patient Icon Association

        //public PatientStubBO GetIconAssociation(Guid patientUID)
        //{
        //    DateTime entryInLogMethodTime = DateTime.UtcNow;
        //    if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
        //    {
        //        InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
        //    }
        //    try
        //    {
        //        if (patientUID == null)
        //            throw new FaultException<NullParameterException>(new NullParameterException()
        //            {
        //                ParameterName = "patientUID",
        //                MethodType = MethodType.Read,
        //                ErrorMessage = Resources.ERR_PATIENT_ICON_ASSOCIATION_NULL_PARAMETER
        //            });
        //        return GetIconAssociationById(patientUID);
        //    }
        //    finally
        //    {
        //        if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
        //        {
        //            InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
        //        }
        //    }
        //}

        public void DeleteIconAssociation(Guid patientUID)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (patientUID == null)
                    throw new FaultException<NullParameterException>(new NullParameterException()
                    {
                        ParameterName = "patientUID",
                        MethodType = MethodType.Delete,
                        ErrorMessage = Resources.ERR_PATIENT_ICON_ASSOCIATION_NULL_PARAMETER
                    });
                RemoveIconAssociation(patientUID);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Patient Location

        public DataContracts.PatientLocation GetPatientLocation(II patientId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (patientId == null || string.IsNullOrEmpty(patientId.root) || string.IsNullOrEmpty(patientId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "patientId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_PATIENT_LOCATION_NULL_PARAMETER });

                DataContracts.PatientLocation patientLocation = new DataContracts.PatientLocation();

                PatientLocationParPO parameters = (PatientLocationParPO)MTServices.Instance[Resources.MT_PatientLocation].Parameters;
                parameters.DOMAIN_ID.Value = patientId.root;
                parameters.PATIENT_UID.Value = Guid.Parse(patientId.extension);

                PatientLocationBO patientLocationBO = MTServices.Instance[Resources.MT_PatientLocation].GetEntityFull(parameters) as PatientLocationBO;

                if (patientLocationBO == null)
                    return null;

                patientLocationBO.CopyTo(patientLocation);
                return patientLocation;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        #endregion

        #region Bed Switch

        public II CreateBedSwitch(DataContracts.BedSwitch bedSwitch)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (bedSwitch == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedSwitch", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_BED_SWITCH_NULL_PARAMETER });

                BedSwitchBO bedSwitchBO = (BedSwitchBO)MTServices.Instance[Resources.MT_BedSwitch].CreateNew();
                bedSwitch.CopyTo(bedSwitchBO);
                bedSwitchBO.Save();

                II id = TranslatorUtils.BuildIdentifier(bedSwitchBO.DOMAIN_ID, bedSwitchBO.ID);
                bedSwitchBO = null;

                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Bed Staff

        public void CreateBedStaff(DataContracts.BedStaff bedStaff)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (bedStaff == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedStaff", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_BED_STAFF_NULL_PARAMETER });

                NewBedStaff(bedStaff);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.BedStaff GetBedStaff(II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (bedId == null || string.IsNullOrEmpty(bedId.extension) || bedId.extension == Guid.Empty.ToString())
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_BED_STAFF_NULL_PARAMETER });

                DataContracts.BedStaff bedStaff = new DataContracts.BedStaff();
                GetBedStaffById(bedId).CopyTo(bedStaff, bedId.root);
                return bedStaff;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteBedStaff(II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (bedId == null || string.IsNullOrEmpty(bedId.extension) || bedId.extension == Guid.Empty.ToString())
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "bedId", MethodType = MethodType.Delete, ErrorMessage = Resources.ERR_BED_STAFF_NULL_PARAMETER });

                RemoveBedStaff(bedId);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region LoggedUser

        public void InsertLoggedUsers(DataContracts.LoggedUser user)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (user == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "user", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_LOGGED_USER_NULL_PARAMETER });

                LoggedUserBO loggedUserBO = (LoggedUserBO)MTServices.Instance[Resources.MT_LoggedUser].CreateNew();
                user.CopyTo(loggedUserBO);
                loggedUserBO.Save();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.LoggedUser> GetLoggedUsers(string domainId, string facilityIdList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.LoggedUser> loggedUserList = new List<DataContracts.LoggedUser>();
                try
                {
                    LoggedUserParPO parameters = (LoggedUserParPO)MTServices.Instance[Resources.MT_LoggedUser].Parameters;
                    parameters.DOMAIN_ID.Value = domainId;
                    parameters.FACILITY_ID_LIST.Value = facilityIdList;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_LoggedUser].GetEntities(parameters);

                    DataContracts.LoggedUser loggedUser = null;
                    foreach (LoggedUserBO bo in listWrapper.ChildList)
                    {
                        loggedUser = new DataContracts.LoggedUser();
                        bo.CopyTo(loggedUser);
                        loggedUserList.Add(loggedUser);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return loggedUserList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void ClearLoggedUsers(string domainId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DataContracts.LoggedUser user = new DataContracts.LoggedUser();
                user.FacilityId = new II(domainId, Guid.Empty.ToString());
                user.VisnId = new II(domainId, Guid.Empty.ToString());
                user.SessionId = "Delete";
                user.UserName = "Delete";
                InsertLoggedUsers(user);
                user = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Ems Staff

        public void CreateEmsStaff(DataContracts.EmsStaff emsStaff)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (emsStaff == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "emsStaff", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_EMS_STAFF_NULL_PARAMETER });

                EmsStaffBO emsStaffBO = (EmsStaffBO)MTServices.Instance[Resources.MT_EmsStaff].CreateNew();
                emsStaff.CopyTo(emsStaffBO);
                emsStaffBO.Save();
                emsStaffBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.EmsStaff GetEmsStaff(II emsStaffId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (emsStaffId == null || string.IsNullOrEmpty(emsStaffId.extension) || int.Parse(emsStaffId.extension) <= 0)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "emsStaffId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_EMS_STAFF_NULL_PARAMETER });

                DataContracts.EmsStaff emsStaff = new DataContracts.EmsStaff();
                GetEmsStaffById(emsStaffId).CopyTo(emsStaff, emsStaffId.root);
                return emsStaff;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteEmsStaff(II emsStaffId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (emsStaffId == null || string.IsNullOrEmpty(emsStaffId.extension) || int.Parse(emsStaffId.extension) <= 0)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "emsStaffId", MethodType = MethodType.Delete, ErrorMessage = Resources.ERR_EMS_STAFF_NULL_PARAMETER });

                EmsStaffBO emsStaffBO = GetEmsStaffById(emsStaffId);
                if (emsStaffBO != null)
                {
                    emsStaffBO.Delete();
                    emsStaffBO = null;
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateEmsStaff(DataContracts.EmsStaff emsStaff)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (emsStaff == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "emsStaff", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_EMS_STAFF_NULL_PARAMETER });

                EmsStaffBO emsStaffBO = GetEmsStaffById(emsStaff.Id);
                if (emsStaffBO != null)
                {
                    emsStaff.CopyTo(emsStaffBO);
                    emsStaffBO.Save();
                    emsStaffBO = null;
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Specialty Transfer

        public void CreateSpecialtyTransfer(DataContracts.SpecialtyTransfer specialtyTransfer)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (specialtyTransfer == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "specialtyTransfer", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_SPECIALTY_TRANSFER_NULL_PARAMETER });

                SpecialtyTransferBO specialtyTransferBO = (SpecialtyTransferBO)MTServices.Instance[Resources.MT_SpecialtyTransfer].CreateNew();
                specialtyTransfer.CopyTo(specialtyTransferBO);
                specialtyTransferBO.Save();
                specialtyTransferBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.SpecialtyTransfer GetSpecialtyTransfer(II specialtyTransferId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (specialtyTransferId == null || string.IsNullOrEmpty(specialtyTransferId.root) || string.IsNullOrEmpty(specialtyTransferId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "specialtyTransferId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_SPECIALTY_TRANSFER_NULL_PARAMETER });

                DataContracts.SpecialtyTransfer specialtyTransfer = new DataContracts.SpecialtyTransfer();
                GetSpecialtyTransferById(specialtyTransferId).CopyTo(specialtyTransfer);
                return specialtyTransfer;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateSpecialtyTransfer(DataContracts.SpecialtyTransfer specialtyTransfer)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (specialtyTransfer == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "specialtyTransfer", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_SPECIALTY_TRANSFER_NULL_PARAMETER });

                SpecialtyTransferBO specialtyTransferBO = GetSpecialtyTransferById(specialtyTransfer.Id);
                if (specialtyTransferBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_SPECIALTY_TRANSFER_NOT_FOUND });

                specialtyTransfer.CopyTo(specialtyTransferBO);
                specialtyTransferBO.Save();
                specialtyTransferBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region HospitalLocationAppointment

        public void CreateHospitalLocationAppointment(DataContracts.HospitalLocationAppointment hospitalLocationAppointment)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (hospitalLocationAppointment == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "hospitalLocationAppointment", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_HOSPITAL_LOCATION_APPOINTMENT_NULL_PARAMETER });

                HospitalLocationAppointmentBO hospitalLocationAppointmentBO = (HospitalLocationAppointmentBO)MTServices.Instance[Resources.MT_HospitalLocationAppointment].CreateNew();
                hospitalLocationAppointment.CopyTo(hospitalLocationAppointmentBO);
                hospitalLocationAppointmentBO.Save();
                hospitalLocationAppointmentBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<DataContracts.HospitalLocationAppointment> GetHospitalLocationsAppointment(Guid? facilityUid, Guid? vistaSiteUid)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.HospitalLocationAppointment> hospitalLocationAppointmentList = new List<DataContracts.HospitalLocationAppointment>();
                try
                {
                    HospitalLocationAppointmentParPO parameters = (HospitalLocationAppointmentParPO)MTServices.Instance[Resources.MT_HospitalLocationAppointment].Parameters;
                    parameters.FACILITY_UID.Value = facilityUid;
                    parameters.VISTA_SITE_UID.Value = vistaSiteUid;

                    IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_HospitalLocationAppointment].GetEntities(parameters);
                    DataContracts.HospitalLocationAppointment hospitalLocationAppointment = null;
                    foreach (HospitalLocationAppointmentBO bo in listWrapper.ChildList)
                    {
                        hospitalLocationAppointment = new DataContracts.HospitalLocationAppointment();
                        bo.CopyTo(hospitalLocationAppointment);
                        hospitalLocationAppointmentList.Add(hospitalLocationAppointment);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                    throw;
                }
                return hospitalLocationAppointmentList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.HospitalLocationAppointment GetHospitalLocationAppointment(II hospitalLocationAppointmentId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (hospitalLocationAppointmentId == null || string.IsNullOrEmpty(hospitalLocationAppointmentId.root) || string.IsNullOrEmpty(hospitalLocationAppointmentId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "hospitalLocationAppointmentId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_HOSPITAL_LOCATION_APPOINTMENT_NULL_PARAMETER });

                DataContracts.HospitalLocationAppointment hospitalLocationAppointment = new DataContracts.HospitalLocationAppointment();
                GetHospitalLocationAppointmentById(hospitalLocationAppointmentId).CopyTo(hospitalLocationAppointment);
                return hospitalLocationAppointment;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void DeleteHospitalLocationAppointment(II hospitalLocationAppointmentId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (hospitalLocationAppointmentId == null || string.IsNullOrEmpty(hospitalLocationAppointmentId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "hospitalLocationAppointmentId", MethodType = MethodType.Delete, ErrorMessage = Resources.ERR_HOSPITAL_LOCATION_APPOINTMENT_NULL_PARAMETER });

                HospitalLocationAppointmentBO hospitalLocationAppointmentBO = GetHospitalLocationAppointmentById(hospitalLocationAppointmentId);
                if (hospitalLocationAppointmentBO != null)
                {
                    hospitalLocationAppointmentBO.Delete();
                    hospitalLocationAppointmentBO = null;
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region Scheduled Admission

        public II CreateScheduledAdmission(DataContracts.ScheduledAdmission scheduledAdmission)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (scheduledAdmission == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "scheduledAdmission", MethodType = MethodType.Create, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NULL_PARAMETER });

                return NewScheduledAdmission(scheduledAdmission);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DataContracts.ScheduledAdmission GetScheduledAdmissionByIen(II vistaId, string ien)
        {
            DataContracts.ScheduledAdmission scheduledAdmission = new DataContracts.ScheduledAdmission();
            ScheduledAdmissionParPO parameters = (ScheduledAdmissionParPO)MTServices.Instance[Resources.MT_ScheduledAdmission].Parameters;
            parameters.DOMAIN_ID.Value = vistaId.root;
            parameters.IEN.Value = ien;
            parameters.VISTA_SITE_UID.Value = vistaId.extension;
            ScheduledAdmissionBO scheduledAdmissionBO = MTServices.Instance[Resources.MT_ScheduledAdmission].GetEntityFull(parameters) as ScheduledAdmissionBO;
            if (scheduledAdmissionBO == null)
                throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NOT_FOUND });
            scheduledAdmissionBO.CopyTo(scheduledAdmission);
            return scheduledAdmission;
        }

        public DataContracts.ScheduledAdmission GetScheduledAdmission(II scheduledAdmissionId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (scheduledAdmissionId == null || string.IsNullOrEmpty(scheduledAdmissionId.root) || string.IsNullOrEmpty(scheduledAdmissionId.extension))
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "scheduledAdmissionId", MethodType = MethodType.Read, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NULL_PARAMETER });

                DataContracts.ScheduledAdmission scheduledAdmission = new DataContracts.ScheduledAdmission();
                GetScheduledAdmissionById(scheduledAdmissionId).CopyTo(scheduledAdmission);
                return scheduledAdmission;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateScheduledAdmission(DataContracts.ScheduledAdmission scheduledAdmission)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (scheduledAdmission == null)
                    throw new FaultException<NullParameterException>(new NullParameterException() { ParameterName = "scheduledAdmission", MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NULL_PARAMETER });

                ModifyScheduledAdmission(scheduledAdmission);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region internal

        internal AdmissionOrderBO GetAdmissionOrderById(II id)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                AdmissionOrderParPO parameters = (AdmissionOrderParPO)MTServices.Instance[Resources.MT_AdmissionOrder].Parameters;
                parameters.DOMAIN_ID.Value = id.root;
                parameters.ID.Value = int.Parse(id.extension);

                AdmissionOrderBO bo = MTServices.Instance[Resources.MT_AdmissionOrder].GetEntityFull(parameters) as AdmissionOrderBO;
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NOT_FOUND });
                return bo;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal AdmissionEvnBO GetAdmissionEventById(II id)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                AdmissionEventParPO parameters = (AdmissionEventParPO)MTServices.Instance[Resources.MT_AdmissionEvent].Parameters;
                parameters.DOMAIN_ID.Value = id.root;
                parameters.ID.Value = int.Parse(id.extension);
                parameters.PATIENT_UID.Value = null;
                parameters.VISTA_SITE_UID.Value = null;
                parameters.EVENT_IEN.Value = null;

                AdmissionEvnBO bo = MTServices.Instance[Resources.MT_AdmissionEvent].GetEntityFull(parameters) as AdmissionEvnBO;
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_ADMISSION_EVENT_NOT_FOUND });
                return bo;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal MovementReqBO GetMovementOrderById(II id)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MovementOrderParPO parameters = (MovementOrderParPO)MTServices.Instance[Resources.MT_MovementOrder].Parameters;
                parameters.DOMAIN_ID.Value = id.root;
                parameters.ID.Value = int.Parse(id.extension);

                MovementReqBO bo = MTServices.Instance[Resources.MT_MovementOrder].GetEntityFull(parameters) as MovementReqBO;
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_MOVEMENT_ORDER_NOT_FOUND });
                return bo;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal MovementEvnBO GetMovementEventById(II id)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MovementEventParPO parameters = (MovementEventParPO)MTServices.Instance[Resources.MT_MovementEvent].Parameters;
                parameters.DOMAIN_ID.Value = id.root;
                parameters.ID.Value = int.Parse(id.extension);

                MovementEvnBO bo = MTServices.Instance[Resources.MT_MovementEvent].GetEntityFull(parameters) as MovementEvnBO;
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_MOVEMENT_EVENT_NOT_FOUND });
                return bo;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal DischargeIntBO GetDischargeAppointmentById(II id)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DischargeAppointmentParPO parameters = (DischargeAppointmentParPO)MTServices.Instance[Resources.MT_DischargeAppointment].Parameters;
                parameters.DOMAIN_ID.Value = id.root;
                parameters.ID.Value = int.Parse(id.extension);

                DischargeIntBO bo = MTServices.Instance[Resources.MT_DischargeAppointment].GetEntityFull(parameters) as DischargeIntBO;
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_DISCHARGE_APPOINTMENT_NOT_FOUND });
                return bo;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal DischargeReqBO GetDischargeOrderById(II id)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DischargeOrderParPO parameters = (DischargeOrderParPO)MTServices.Instance[Resources.MT_DischargeOrder].Parameters;
                parameters.DOMAIN_ID.Value = id.root;
                parameters.ID.Value = int.Parse(id.extension);

                DischargeReqBO bo = MTServices.Instance[Resources.MT_DischargeOrder].GetEntityFull(parameters) as DischargeReqBO;
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_DISCHARGE_ORDER_NOT_FOUND });
                return bo;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal DischargeEvnBO GetDischargeEventById(II id)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DischargeEventParPO parameters = (DischargeEventParPO)MTServices.Instance[Resources.MT_DischargeEvent].Parameters;
                parameters.DOMAIN_ID.Value = id.root;
                parameters.ID.Value = int.Parse(id.extension);

                DischargeEvnBO bo = MTServices.Instance[Resources.MT_DischargeEvent].GetEntityFull(parameters) as DischargeEvnBO;
                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_DISCHARGE_EVENT_NOT_FOUND });
                return bo;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        
        internal ScheduledAdmissionBO GetScheduledAdmissionById(II scheduledAdmissionId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ScheduledAdmissionParPO parameters = (ScheduledAdmissionParPO)MTServices.Instance[Resources.MT_ScheduledAdmission].Parameters;
                parameters.DOMAIN_ID.Value = scheduledAdmissionId.root;
                parameters.ID.Value = int.Parse(scheduledAdmissionId.extension);

                ScheduledAdmissionBO scheduledAdmissionBO = MTServices.Instance[Resources.MT_ScheduledAdmission].GetEntityFull(parameters) as ScheduledAdmissionBO;

                if (scheduledAdmissionBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NOT_FOUND });

                return scheduledAdmissionBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal II NewScheduledAdmission(DataContracts.ScheduledAdmission request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ScheduledAdmissionBO scheduledAdmissionBO = (ScheduledAdmissionBO)MTServices.Instance[Resources.MT_ScheduledAdmission].CreateNew();
                request.CopyTo(scheduledAdmissionBO);
                scheduledAdmissionBO.Save();

                II id = TranslatorUtils.BuildIdentifier(scheduledAdmissionBO.DOMAIN_ID, scheduledAdmissionBO.ID);
                scheduledAdmissionBO = null;

                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void ModifyScheduledAdmission(DataContracts.ScheduledAdmission request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ScheduledAdmissionBO scheduledAdmissionBO = GetScheduledAdmissionById(request.Id);
                if (scheduledAdmissionBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ADMISSION_ORDER_NOT_FOUND });

                request.CopyTo(scheduledAdmissionBO);

                scheduledAdmissionBO.Save();

                scheduledAdmissionBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal TransferBO GetTransferById(II transferId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                TransferParPO parameters = (TransferParPO)MTServices.Instance[Resources.MT_Transfer].Parameters;
                parameters.DOMAIN_ID.Value = transferId.root;
                parameters.ACT_ID.Value = int.Parse(transferId.extension);

                TransferBO transferBO = MTServices.Instance[Resources.MT_Transfer].GetEntityFull(parameters) as TransferBO;

                if (transferBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_TRANSFER_NOT_FOUND });

                return transferBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal II NewTransfer(DataContracts.Transfer request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                TransferBO transferBO = (TransferBO)MTServices.Instance[Resources.MT_Transfer].CreateNew();
                request.CopyTo(transferBO);
                transferBO.Save();

                II id = TranslatorUtils.BuildIdentifier(transferBO.DOMAIN_ID, transferBO.ACT_ID);
                transferBO = null;

                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void ModifyTransfer(DataContracts.Transfer request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                TransferBO transferBO = GetTransferById(request.Id);
                if (transferBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_TRANSFER_NOT_FOUND });
                request.CreationDate = transferBO.CREATION_DATE.Value;
                request.CopyTo(transferBO);

                transferBO.Save();

                transferBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal BedCleanBO GetBedCleaningById(II bedCleaningId, II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedCleaningParPO parameters = (BedCleaningParPO)MTServices.Instance[Resources.MT_BedCleaning].Parameters;
                parameters.DOMAIN_ID.Value = (bedCleaningId != null) ? bedCleaningId.root : bedId.root;
                if (bedCleaningId == null)
                    parameters.ID.Value = null;
                else
                    parameters.ID.Value = int.Parse(bedCleaningId.extension);
                if (bedId == null)
                    parameters.BED_UID.Value = null;
                else
                    parameters.BED_UID.Value = Guid.Parse(bedId.extension);

                BedCleanBO bedCleaningBO = MTServices.Instance[Resources.MT_BedCleaning].GetEntityFull(parameters) as BedCleanBO;

                if (bedCleaningBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_BED_CLEANING_NOT_FOUND });

                return bedCleaningBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal II NewBedCleaning(DataContracts.BedCleaningOperation request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedCleanBO bedCleaningBO = (BedCleanBO)MTServices.Instance[Resources.MT_BedCleaning].CreateNew();
                request.CopyTo(bedCleaningBO);
                bedCleaningBO.Save();

                II id = TranslatorUtils.BuildIdentifier(bedCleaningBO.DOMAIN_ID, bedCleaningBO.ID);
                bedCleaningBO = null;

                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void ModifyBedCleaning(DataContracts.BedCleaningOperation request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedCleanBO bedCleaningBO = GetBedCleaningById(request.Id, null);
                if (bedCleaningBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_BED_CLEANING_NOT_FOUND });
                request.CopyTo(bedCleaningBO);
                bedCleaningBO.Save();
                bedCleaningBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal BedUnavailableBO GetBedUnavailableById(II bedUnavailableId, II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedUnavailableParPO parameters = (BedUnavailableParPO)MTServices.Instance[Resources.MT_BedUnavailable].Parameters;
                parameters.DOMAIN_ID.Value = (bedUnavailableId == null) ? bedId.root : bedUnavailableId.root;
                if (bedUnavailableId == null)
                    parameters.ACT_ID.Value = null;
                else
                    parameters.ACT_ID.Value = int.Parse(bedUnavailableId.extension);
                if (bedId == null)
                    parameters.BED_UID.Value = null;
                else
                    parameters.BED_UID.Value = Guid.Parse(bedId.extension);

                BedUnavailableBO bedUnavailableBO = MTServices.Instance[Resources.MT_BedUnavailable].GetEntityFull(parameters) as BedUnavailableBO;

                if (bedUnavailableBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_BED_UNAVAILABLE_NOT_FOUND });

                return bedUnavailableBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal II NewBedUnavailable(DataContracts.BedUnavailable request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedUnavailableBO bedUnavailableBO = (BedUnavailableBO)MTServices.Instance[Resources.MT_BedUnavailable].CreateNew();
                request.CopyTo(bedUnavailableBO);
                bedUnavailableBO.Save();
                II id = TranslatorUtils.BuildIdentifier(bedUnavailableBO.DOMAIN_ID, bedUnavailableBO.ACT_ID);

                bedUnavailableBO = null;

                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void ModifyBedUnavailable(DataContracts.BedUnavailable request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedUnavailableBO bedUnavailableBO = GetBedUnavailableById(request.Id, null);
                if (bedUnavailableBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_BED_UNAVAILABLE_NOT_FOUND });

                request.CreationDate = bedUnavailableBO.CREATION_DATE.Value;
                request.CopyTo(bedUnavailableBO);

                bedUnavailableBO.Save();

                bedUnavailableBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }        

        internal DiversionBO GetDiversionById(II diversionId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DiversionParPO parameters = (DiversionParPO)MTServices.Instance[Resources.MT_Diversion].Parameters;
                parameters.DIVERSION_ID.Value = int.Parse(diversionId.extension);
                parameters.DOMAIN_ID.Value = diversionId.root;
                parameters.FACILITY_UID.Value = null;

                DiversionBO diversionBO = MTServices.Instance[Resources.MT_Diversion].GetEntityFull(parameters) as DiversionBO;

                if (diversionBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_DIVERSION_NOT_FOUND });

                return diversionBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal List<DiversionBO> GetDiversions(II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DiversionParPO parameters = (DiversionParPO)MTServices.Instance[Resources.MT_Diversion].Parameters;
                parameters.DIVERSION_ID.Value = null;
                parameters.DOMAIN_ID.Value = null;
                parameters.FACILITY_UID.Value = Guid.Parse(facilityId.extension);

                List<DiversionBO> listDiversionBO = new List<DiversionBO>();
                IEntityListWrapper listWrapper = MTServices.Instance[Resources.MT_Diversion].GetEntities(parameters);

                foreach (DiversionBO bo in listWrapper.ChildList)
                    listDiversionBO.Add(bo);

                return listDiversionBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal II NewDiversion(DataContracts.Diversion request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DiversionBO diversionBO = (DiversionBO)MTServices.Instance[Resources.MT_Diversion].CreateNew();
                request.CopyTo(diversionBO);
                diversionBO.Save();
                II id = TranslatorUtils.BuildIdentifier(diversionBO.DOMAIN_ID, diversionBO.DIVERSION_ID);
                diversionBO = null;

                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void ModifyDiversion(DataContracts.Diversion request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DiversionBO diversionBO = GetDiversionById(request.Id);
                if (diversionBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_DIVERSION_NOT_FOUND });

                request.CopyTo(diversionBO);

                diversionBO.Save();

                diversionBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }        

        internal WaitingListItemBO GetWaitingListItemById(II waitingListItemId, string patientUid)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                WaitinglistitemparPO parameters = (WaitinglistitemparPO)MTServices.Instance[Resources.MT_WaitingListItem].Parameters;
                parameters.DOMAIN_ID.Value = (waitingListItemId != null) ? waitingListItemId.root : null;
                if (waitingListItemId != null)
                    parameters.ACT_ID.Value = int.Parse(waitingListItemId.extension);
                else
                    parameters.ACT_ID.Value = null;
                parameters.PATIENT_UID.Value = (!string.IsNullOrEmpty(patientUid) && !patientUid.Equals(Guid.Empty)) ? Guid.Parse(patientUid) : (Guid?)null;

                WaitingListItemBO waitingListItemBO = MTServices.Instance[Resources.MT_WaitingListItem].GetEntityFull(parameters) as WaitingListItemBO;

                if (waitingListItemBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException()
                    {
                        MethodType = MethodType.Read,
                        ErrorMessage = Resources.ERR_WAITING_LIST_NOT_FOUND
                    });

                return waitingListItemBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal II NewWaitingListItem(DataContracts.WaitingListItem request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                WaitingListItemBO waitingListItemBO = (WaitingListItemBO)MTServices.Instance[Resources.MT_WaitingListItem].CreateNew();
                request.CopyTo(waitingListItemBO);
                waitingListItemBO.Save();

                II id = TranslatorUtils.BuildIdentifier(waitingListItemBO.DOMAIN_ID, waitingListItemBO.ACT_ID);
                waitingListItemBO = null;

                return id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void ModifyWaitingListItem(DataContracts.WaitingListItem request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                WaitingListItemBO waitingListItemBO = GetWaitingListItemById(request.Id, null);
                if (waitingListItemBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException()
                    {
                        MethodType = MethodType.Update,
                        ErrorMessage = Resources.ERR_WAITING_LIST_NOT_FOUND
                    });

                request.CreationDate = waitingListItemBO.CREATION_DATE.Value;
                request.CopyTo(waitingListItemBO);

                waitingListItemBO.Save();

                waitingListItemBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void NewBedUnvailableHistory(DataContracts.BedUnavailableHistory bed)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedUnavailableHistoryBO bedUnavailableBO = (BedUnavailableHistoryBO)MTServices.Instance[Resources.MT_BedUnavailableHistory].CreateNew();
                bed.CopyTo(bedUnavailableBO);
                bedUnavailableBO.Save();
                bedUnavailableBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal IconDetailBO GetIconDetailById(int iconDetailId, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconDetailParPO parameters = (IconDetailParPO)MTServices.Instance[Resources.MT_IconDetail].Parameters;
                parameters.ICON_ID.Value = iconDetailId;
                if (facilityId != null)
                    parameters.FACILITY_UID.Value = Guid.Parse(facilityId.extension);
                else
                    parameters.FACILITY_UID.Value = null;                    
                return MTServices.Instance[Resources.MT_IconDetail].GetEntityFull(parameters) as IconDetailBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal int NewIconDetail(DataContracts.IconDetail request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconDetailBO iconDetailBO = (IconDetailBO)MTServices.Instance[Resources.MT_IconDetail].CreateNew();
                request.CopyTo(iconDetailBO);
                iconDetailBO.Save();

                int result = iconDetailBO.ID.Value.Value;
                iconDetailBO = null;
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void ModifyIconDetail(DataContracts.IconDetail request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconDetailBO iconDetailBO = GetIconDetailById(request.Id, request.FacilityId);
                if (iconDetailBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ICON_DETAIL_NOT_FOUND });

                request.CopyTo(iconDetailBO);
                iconDetailBO.Save();
                iconDetailBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void RemoveIconDetail(int iconDetailId, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconDetailBO iconDetailBO = GetIconDetailById(iconDetailId, facilityId);
                if (iconDetailBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ICON_DETAIL_NOT_FOUND });

                iconDetailBO.Delete();
                iconDetailBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void InsertIconDetail(DataContracts.IconAssociation request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconAssociationBO iconAssociationBO = (IconAssociationBO)MTServices.Instance[Resources.MT_IconAssociation].CreateNew();
                request.CopyTo(iconAssociationBO);
                iconAssociationBO.Save();
                iconAssociationBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void SwitchIconOrderIndexes(DataContracts.IconInfo icon1, DataContracts.IconInfo icon2)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconDetailBO iconDetailBO1 = GetIconDetailById(icon1.IconId, icon1.FacilityId);
                if (iconDetailBO1 == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ICON_DETAIL_NOT_FOUND });
                IconDetailBO iconDetailBO2 = GetIconDetailById(icon2.IconId, icon2.FacilityId);
                if (iconDetailBO2 == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_ICON_DETAIL_NOT_FOUND });

                iconDetailBO1.ORDER_INDEX.Value = icon2.OrderIndex;
                iconDetailBO2.ORDER_INDEX.Value = icon1.OrderIndex;

                iconDetailBO1.Save();
                iconDetailBO2.Save();

                iconDetailBO1 = null;
                iconDetailBO2 = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void ModifyIconOrderBulk(List<DataContracts.IconOrder> iconOrderList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconOrderBO iconOrderBO = (IconOrderBO)MTServices.Instance[Resources.MT_IconOrder].CreateNew();
                iconOrderList.CopyTo(iconOrderBO);
                iconOrderBO.Save();
                iconOrderBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal PatientStubBO GetIconAssociationById(Guid patientUID)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                PatientIconAssociationParPO parameters = (PatientIconAssociationParPO)MTServices.Instance[Resources.MT_PatientIconAssociation].Parameters;
                parameters.PATIENT_UID.Value = patientUID;

                return MTServices.Instance[Resources.MT_PatientIconAssociation].GetEntityFull(parameters) as PatientStubBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void RemoveIconAssociation(Guid patientUID)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                PatientStubBO patientStubBO = GetIconAssociationById(patientUID);
                if (patientStubBO != null)
                {
                    patientStubBO.Delete();
                    patientStubBO = null;
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal BedStaffBO GetBedStaffById(II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedStaffParPO parameters = (BedStaffParPO)MTServices.Instance[Resources.MT_BedStaff].Parameters;
                parameters.BED_UID.Value = Guid.Parse(bedId.extension);

                return MTServices.Instance[Resources.MT_BedStaff].GetEntityFull(parameters) as BedStaffBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void NewBedStaff(DataContracts.BedStaff request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedStaffBO bedStaffBO = (BedStaffBO)MTServices.Instance[Resources.MT_BedStaff].CreateNew();
                request.CopyTo(bedStaffBO);
                bedStaffBO.Save();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal void RemoveBedStaff(II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedStaffBO bedStaffBO = GetBedStaffById(bedId);
                if (bedStaffBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Update, ErrorMessage = Resources.ERR_BED_STAFF_NOT_FOUND });

                bedStaffBO.Delete();
                bedStaffBO = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal EmsStaffBO GetEmsStaffById(II emsStaffId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                EmsStaffParPO parameters = (EmsStaffParPO)MTServices.Instance[Resources.MT_EmsStaff].Parameters;
                parameters.ID.Value = int.Parse(emsStaffId.extension);
                parameters.FACILITY_UID.Value = null;

                return MTServices.Instance[Resources.MT_EmsStaff].GetEntityFull(parameters) as EmsStaffBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private static object _lockJobAudit = new object();

        public int AddLogEntry(JobLogInfo logEntry)
        {
            if (logEntry == null)
                throw new ArgumentNullException("logEntry");

            lock (_lockJobAudit)
            {
                JobAuditBO auditBO = (JobAuditBO)MTServices.Instance[Resources.MT_JobAudit].CreateNew();
                logEntry.CopyTo(auditBO);                
                auditBO.Save();
                int id = auditBO.ID.Value;
                return id;
            }
        }

        public void UpdateLogEntry(JobLogInfo logEntry)
        {
            if (logEntry == null)
                throw new ArgumentNullException("logEntry");

            lock (_lockJobAudit)
            {
                JobAuditBO auditBO = (JobAuditBO)MTServices.Instance[Resources.MT_JobAudit].GetEntityByID(logEntry.Id);                
                logEntry.CopyTo(auditBO);
                auditBO.Save();
            }
        }

        internal SpecialtyTransferBO GetSpecialtyTransferById(II specialtyTransferId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SpecialtyTransferParPO parameters = (SpecialtyTransferParPO)MTServices.Instance[Resources.MT_SpecialtyTransfer].Parameters;
                parameters.DOMAIN_ID.Value = specialtyTransferId.root;
                parameters.ID.Value = int.Parse(specialtyTransferId.extension);

                SpecialtyTransferBO specialtyTransferBO = MTServices.Instance[Resources.MT_SpecialtyTransfer].GetEntityFull(parameters) as SpecialtyTransferBO;

                if (specialtyTransferBO == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_SPECIALTY_TRANSFER_NOT_FOUND });

                return specialtyTransferBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        internal HospitalLocationAppointmentBO GetHospitalLocationAppointmentById(II hospitalLocationAppointmentId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                HospitalLocationAppointmentParPO parameters = (HospitalLocationAppointmentParPO)MTServices.Instance[Resources.MT_HospitalLocationAppointment].Parameters;
                parameters.ID.Value = int.Parse(hospitalLocationAppointmentId.extension);
                parameters.FACILITY_UID.Value = null;
                parameters.VISTA_SITE_UID.Value = null;

                HospitalLocationAppointmentBO bo = MTServices.Instance[Resources.MT_HospitalLocationAppointment].GetEntityFull(parameters) as HospitalLocationAppointmentBO;

                if (bo == null)
                    throw new FaultException<EntityNotFoundException>(new EntityNotFoundException() { MethodType = MethodType.Read, ErrorMessage = Resources.ERR_HOSPITAL_LOCATION_APPOINTMENT_NOT_FOUND });

                return bo;
            }
            catch (Exception ex)
            {
                Tracer.TraceException(ex);
                throw;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public IList<BMS.DataContracts.VistaOperation> GetData(string vistaId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<BMS.DataContracts.VistaOperation> result = new List<DataContracts.VistaOperation>(BMS.VistaIntegration.Utilities.VistATypes.Count);
                foreach (var type in BMS.VistaIntegration.Utilities.VistATypes)
                {
                    VistaOperationsBO vistaOpBO = GetOperationBO(vistaId, type);
                    var operation = new BMS.DataContracts.VistaOperation()
                    {
                        DataType = type,
                        VistaSiteId = vistaId,
                        LastRunning = vistaOpBO.LAST_RUNNING.Value,
                        CounterFailed = vistaOpBO.COUNTER_FAILED.Value
                    };
                    result.Add(operation);
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private VistaOperationsBO GetOperationBO(string vistaId, VistaDataType type)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                VistaoperationparPO parameters = (VistaoperationparPO)MTServices.Instance[Resources.MT_VistaOperation].Parameters;
                parameters.VISTA_ID.Value = vistaId;
                parameters.OPERATION_ID.Value = (int)type;
                VistaOperationsBO operationBO = MTServices.Instance[Resources.MT_VistaOperation].GetEntityFull(parameters) as VistaOperationsBO;
                if (operationBO == null)
                    operationBO = CreateNew(vistaId, type);
                return operationBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateData(BMS.DataContracts.VistaOperation vistaOperation)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                VistaOperationsBO vistaOpBO = GetOperationBO(vistaOperation.VistaSiteId, vistaOperation.DataType);
                vistaOpBO.LAST_RUNNING.Value = vistaOperation.LastRunning;
                vistaOpBO.COUNTER_FAILED.Value = vistaOperation.CounterFailed;
                vistaOpBO.Save();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public void DeleteData(string vistaId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                foreach (var type in BMS.VistaIntegration.Utilities.VistATypes)
                {
                    VistaOperationsBO vistaOpBO = GetOperationBO(vistaId, type);
                    if (vistaOpBO != null)
                        vistaOpBO.Delete();
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private VistaOperationsBO CreateNew(string vistaId, VistaDataType type)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                VistaOperationsBO vistaOpBO = MTServices.Instance[Resources.MT_VistaOperation].CreateNew() as VistaOperationsBO;
                vistaOpBO.VISTA_ID.Value = vistaId;
                vistaOpBO.OPERATION_ID.Value = (int)type;
                vistaOpBO.LAST_RUNNING.Value = null;
                vistaOpBO.COUNTER_FAILED.Value = 0;
                vistaOpBO.Save();
                return vistaOpBO;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void SaveLevelOfCare(LevelOfCareData data)
        {
            AdmissionLevelOfCareParPO parameters = (AdmissionLevelOfCareParPO)MTServices.Instance[Resources.MT_AdmissionLevelOfCare].Parameters;
            parameters.ASSIGNMENT_DATE.Value = data.AssignmentDate;
            parameters.LEVEL_OF_CARE.Value = data.LevelOfCare;
            parameters.PATIENT_UID.Value = Guid.Parse(data.PatientId.extension);
            parameters.WARD_LIST.Value = GetWardsParam(data.WardsId);
            MTServices.Instance[Resources.MT_AdmissionLevelOfCare].GetEntityFull(parameters);
        }

        private static string GetWardsParam(IEnumerable<II> wardsId)
        {
            if (!wardsId.Any()) return string.Empty;

            StringBuilder sb = new StringBuilder();
            wardsId.ForEach(id =>
            {
                sb.Append(id.extension);
                sb.Append(',');
            });
            sb.Remove(sb.Length - 1, 1);
            return sb.ToString();
        }

        public void SaveVistaIntegrationLog(DataContracts.VistaIntegrationLog vistaIntegrationLog, string vista)
        {
            VistaIntegrationLogBO value = MTServices.Instance[Resources.MT_VistaIntegrationLog].CreateNew() as VistaIntegrationLogBO;
            value.IEN.Value = vistaIntegrationLog.Ien;
            value.VISTA_FILE.Value = vistaIntegrationLog.File;
            value.VISTA.Value = vista;
            value.Save();
        }

        public void ManageDeletedMovements(string iens, II vistaId, string vistaCode)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MovementIenBO bo = (MovementIenBO)MTServices.Instance[Resources.MT_MovementIen].CreateNew();
                bo.IEN.Value = iens;
                bo.VISTA_SITE_UID.Value = Guid.Parse(vistaId.extension);
                bo.VISTA_SITE_CODE.Value = vistaCode;
                //lock (_lockMovementEvents)               
                int retry = 0;
                while (retry < 3)
                {
                    try
                    {
                        bo.Save();
                        retry = 3;
                    }
                    catch (System.Data.SqlClient.SqlException sqlEx)
                    {
                        if (sqlEx.Number == 1205) //Deadlock
                        {
                            if (retry == 2)
                            {
                                Tracer.TraceException(sqlEx);
                                throw sqlEx;
                            }
                            else
                            {
                                retry++;
                                Tracer.TraceMessage("BMSService ManageDeletedMovements deadlock. Retry: " + retry.ToString());
                            }
                        }
                        else
                        {
                            retry = 3;
                            Tracer.TraceException(sqlEx);
                            throw sqlEx;
                        }
                    }
                    catch (Exception ex)
                    {
                        retry = 3;
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                }
                bo = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        // the "iens" parameter contains multiple movements data with the format: ien, ward_uid, bed_uid, ien, ward_uid, bed_uid, .....
        public void UpdateMovementsWithoutBed(string iens, II vistaId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                MovementWithoutBedBO bo = (MovementWithoutBedBO)MTServices.Instance[Resources.MT_MovementWithoutBed].CreateNew();
                bo.IEN.Value = iens;
                bo.VISTA_SITE_UID.Value = Guid.Parse(vistaId.extension);                
                bo.Save();
                bo = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

		/// <summary>
		/// Updates audit jobs failed with status running to failed.
		/// </summary>
		public void UpdateAuditJobsFailedWithStatusRunningToFailed()
		{
			DateTime entryInLogMethodTime = DateTime.UtcNow;
			if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
			{
				InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
			}
			try
			{
				JobAuditOperationsBO bo = (JobAuditOperationsBO)MTServices.Instance[Resources.MT_JobAuditOperations].CreateNew();
				bo.Save();
				bo = null;
			}
			finally
			{
				if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
				{
					InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
				}
			}
		}

        public string GetVistaPatientIen(string vistaCode)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string result = null;
                if (!string.IsNullOrEmpty(vistaCode))
                {
                    VistaPatientIenParPO parameters = (VistaPatientIenParPO)MTServices.Instance[Resources.MT_VistaPatientIen].Parameters;
                    parameters.VISTA_CODE.Value = vistaCode;

                    VistaPatientIenBO bo = MTServices.Instance[Resources.MT_VistaPatientIen].GetEntityFull(parameters) as VistaPatientIenBO;
                    if (bo != null)                    
                        result = bo.PATIENT_IEN.Value;                    
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
