using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace InfoWorld.Security.Authorization.PolicyAdministrationPoint
{
    /// <summary>
    /// Class which holds information about a subscription to synchronization messages.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.Runtime.Serialization", "3.0.0.0")]
    [System.Runtime.Serialization.DataContractAttribute(Name = "Subscription", Namespace = "http://schemas.datacontract.org/2004/07/InfoWorld.Security.Authorization.PolicyAdministrationPoint")]
    [System.SerializableAttribute()]
    public partial class Subscription : object, System.Runtime.Serialization.IExtensibleDataObject
    {
        [System.NonSerializedAttribute()]
        private System.Runtime.Serialization.ExtensionDataObject extensionDataField;

        public System.Runtime.Serialization.ExtensionDataObject ExtensionData
        {
            get
            {
                return this.extensionDataField;
            }
            set
            {
                this.extensionDataField = value;
            }
        }

        [System.Runtime.Serialization.OptionalFieldAttribute()]
        string publisherEndpoint;
        [System.Runtime.Serialization.OptionalFieldAttribute()]
        string subscriptionTopic;
        [System.Runtime.Serialization.OptionalFieldAttribute()]
        string deliveryMode;
        [System.Runtime.Serialization.OptionalFieldAttribute()]
        string endpointAddress;
        [System.Runtime.Serialization.OptionalFieldAttribute()]
        DateTime expiresDays;
        [System.Runtime.Serialization.OptionalFieldAttribute()]
        string subscriptionId;

        /// <summary>
        /// Initializes a new instance of the <see cref="Subscription"/> class.
        /// </summary>
        public Subscription() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Subscription"/> class with the subscription data.
        /// </summary>
        /// <param name="publisherEndpoint">The publisher endpoint.</param>
        /// <param name="subscriptionTopic">The subscription topic.</param>
        /// <param name="deliveryMode">The delivery mode.</param>
        /// <param name="endpointAddress">The endpoint address.</param>
        /// <param name="expiresDays">The validity period.</param>
        /// <param name="subscriptionId">The subscription id.</param>
        public Subscription(string publisherEndpoint, string subscriptionTopic, string deliveryMode,
            string endpointAddress, DateTime expiresDays, string subscriptionId)
        {
            this.publisherEndpoint = publisherEndpoint;
            this.subscriptionTopic = subscriptionTopic;
            this.deliveryMode = deliveryMode;
            this.endpointAddress = endpointAddress;
            this.expiresDays = expiresDays;
            this.subscriptionId = subscriptionId;
        }

        /// <summary>
        /// Gets or sets the publisher endpoint.
        /// </summary>
        /// <value>
        /// The publisher endpoint.
        /// </value>
        [System.Runtime.Serialization.DataMemberAttribute()]
        public string PublisherEndpoint
        {
            get { return publisherEndpoint; }
            set { publisherEndpoint = value; }
        }
        /// <summary>
        /// Gets or sets the subscription topic.
        /// </summary>
        /// <value>
        /// The subscription topic.
        /// </value>
        [System.Runtime.Serialization.DataMemberAttribute()]
        public string SubscriptionTopic
        {
            get { return subscriptionTopic; }
            set { subscriptionTopic = value; }
        }
        /// <summary>
        /// Gets or sets the delivery mode.
        /// </summary>
        /// <value>
        /// The delivery mode.
        /// </value>
        [System.Runtime.Serialization.DataMemberAttribute()]
        public string DeliveryMode
        {
            get { return deliveryMode; }
            set { deliveryMode = value; }
        }
        /// <summary>
        /// Gets or sets the endpoint address.
        /// </summary>
        /// <value>
        /// The endpoint address.
        /// </value>
        [System.Runtime.Serialization.DataMemberAttribute()]
        public string EndpointAddress
        {
            get { return endpointAddress; }
            set { endpointAddress = value; }
        }
        /// <summary>
        /// Gets or sets the validity period.
        /// </summary>
        /// <value>
        /// The validity period.
        /// </value>
        [System.Runtime.Serialization.DataMemberAttribute()]
        public DateTime ExpiresDays
        {
            get { return expiresDays; }
            set { expiresDays = value; }
        }
        /// <summary>
        /// Gets or sets the subscription id.
        /// </summary>
        /// <value>
        /// The subscription id.
        /// </value>
        [System.Runtime.Serialization.DataMemberAttribute()]
        public string SubscriptionId
        {
            get { return subscriptionId; }
            set { subscriptionId = value; }
        }
    }
}
