﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Schedulers;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.ServicesWrapper.EIS;
using InfoWorld.HL7.ITS;
using BMS.DataContracts;
using BMS.ServicesWrapper.BMService;
using BMS.ServicesWrapper.Proxy;
using System.Configuration;

namespace BMS.Numi
{
    public class NumiCommand : BaseCommand
    {
        public IList<VistaSite> vistASites;
        private static BmsLogger logger = new BmsLogger("Numi:");

        public NumiCommand(IList<VistaSite> vistASites)
        {
            this.vistASites = vistASites;
        }

        protected override void DoRun(Scheduler scheduler)
        {
            string authenticationKey = ConfigurationManager.AppSettings["NumiSvcAuthenticationKey"];
            if (string.IsNullOrEmpty(authenticationKey))
            {
                logger.LogError("NumiSvcAuthenticationKey not found in appSettings section of the config file!");
                return;
            }

            StringBuilder sb = new StringBuilder();
            Dictionary<string, List<II>> wards = new Dictionary<string, List<II>>();
            ExchangeAuthentication ea = new ExchangeAuthentication();

            ea.AuthenticationID = new Guid(authenticationKey);

            int maxNumberOfSitesPerCall = 0;
            try
            {
                maxNumberOfSitesPerCall = int.Parse(ConfigurationManager.AppSettings["NumiMaxNumberOfSitesPerCall"]);
            }
            catch { maxNumberOfSitesPerCall = 5; }
            
            try
            {
                int count = 0;
                Dictionary<string, ExchangeItem> numiResults = new Dictionary<string, ExchangeItem>();
                TimeZoneInfo timeZoneInfo;
                VistASettings vistaSettings = null;

                foreach (VistaSite site in vistASites)
                {
                    wards.Add(site.Number, EISFactory.InstanceWindows.GetWardsByVistaSiteId(site.Id).Select(w => w.Id).ToList());                    
                    sb.Append(site.Number);
                    sb.Append(",");
                    count = count + 1;
                    if (count == maxNumberOfSitesPerCall)
                    {
                        if (sb.Length > 0)
                        {
                            sb = sb.Remove(sb.Length - 1, 1);
                            numiResults.Add(sb.ToString(), BMSFactory.InpatientSoapClientWindows.GetLevelOfCareBySite(ea, sb.ToString()));
                        }
                        count = 0;
                        sb.Clear();
                    }
                }
                if (count > 0)
                {
                    if (sb.Length > 0)
                    {
                        sb = sb.Remove(sb.Length - 1, 1);
                        numiResults.Add(sb.ToString(), BMSFactory.InpatientSoapClientWindows.GetLevelOfCareBySite(ea, sb.ToString()));
                    }
                }

                foreach (KeyValuePair<string, ExchangeItem> pair in numiResults)
                {
                    if (pair.Value == null)
                        logger.LogFormat(BmsLogger.Level.Error, "Numi scheduler - sites: {0}  An unkown error has occurred.", pair.Key);
                    else
                    {
                        if (pair.Value.LevelOfCareArray == null || pair.Value.LevelOfCareArray.Length == 0)
                        {
                            if (!string.IsNullOrEmpty(pair.Value.Message))
                                logger.LogFormat(BmsLogger.Level.Error, "Numi scheduler - sites: {0} Message: {1}", pair.Key, pair.Value.Message);
                            else
                                logger.LogFormat(BmsLogger.Level.Error, "Numi scheduler - sites: {0} No items returned.", pair.Key);
                        }
                        else
                        {
                            //  List<LevelOfCareData> data = pair.Value.LevelOfCareArray.Where(a => a.LevelOfCare != null).Select<ExchangeLevelOfCare, LevelOfCareData>(s => Translate(s, wards.ContainsKey(s.SiteCode) ? wards[s.SiteCode] : null)).ToList();
                            foreach (ExchangeLevelOfCare levelOfCare in pair.Value.LevelOfCareArray)
                            {
                                LevelOfCareData obj = Translate(levelOfCare, wards.ContainsKey(levelOfCare.SiteCode) ? wards[levelOfCare.SiteCode] : null);
                                if (obj != null && obj.PatientId != null)
                                {
                                    II vistaII = vistASites.Any(s => s.Number == levelOfCare.SiteCode) ? vistASites.First(s => s.Number == levelOfCare.SiteCode).Id : null;
                                    if (vistaII != null)
                                    {
                                        //get TimeZoneInfo of the VistA Site
                                        vistaSettings = Facade.FacadeManager.ConfigurationInterface.GetVistASettings(vistaII);
                                        if (vistaSettings != null && vistaSettings.SiteTimeZone != null)
                                        {
                                            timeZoneInfo = TimeZoneInfo.FindSystemTimeZoneById(vistaSettings.SiteTimeZone.displayName);
                                            BMS.Facade.TimeZoneUtil.ConvertObjectDates(obj, false, timeZoneInfo);
                                        }
                                    }
                                    BMSFactory.BedManagerOperationsClientWindows.SaveLevelOfCare(obj);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Tracer.TraceException(ex);
            }            
        }

        private static LevelOfCareData Translate(ExchangeLevelOfCare obj, List<II> wards)
        {
            if (wards == null) return null;
            LevelOfCareData data = new LevelOfCareData();
            data.AssignmentDate = obj.AssignmentDate;
            data.LevelOfCare = (obj.LevelOfCare.HasValue) ? obj.LevelOfCare.Value.ToString() : null;
            Patient patient = EISFactory.InstanceWindows.GetPatientBySsn(new II(Constants.SSNROOT, GetSsn(obj.PatientSsn)), null); 
            data.PatientId = patient != null ? patient.Id : null;
            data.WardsId = wards;
            return data;
        }

        private static string GetSsn(string value)
        {
            if (string.IsNullOrEmpty(value))
                return null;
            if (value.Contains("-") || value.Length < 9) 
                return value;
            else 
                return value.Insert(3, "-").Insert(6, "-");
        }
    }
}
