﻿using System;
using BMS.Facade.Service;
using VI = BMS.VistaIntegration.FacadeContracts;
using System.ServiceModel;
using BMS.ServicesWrapper.BMService;
using System.Collections.Generic;
using BMS.VistaIntegration.FacadeContracts.Admin;
using BMS.Utils;
using System.Linq;
using DC = BMS.DataContracts;
using BMS.Facade.Translators;

namespace BMS.Facade.Implementation
{
    public class VistAIntegrationOperationsImplementation : IVistAIntegrationOperations
    {
        public void RunOnDemand(VI.VistASite site, VI.Admin.VistaDataType types, DateTime? startDate, DateTime? endDate, DataRetrievalMethod retrievalMethod)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DataContracts.VistASite vistaSite = GetVistaSite(site, retrievalMethod);

                Utils.VistaDataType dataType = (Utils.VistaDataType)((int)types);

                RunOnDemand(vistaSite, dataType, startDate, endDate, retrievalMethod);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public string TestConnection(VI.VistASite site, DataRetrievalMethod retrievalMethod)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    TestConnection(GetVistaSite(site, retrievalMethod), retrievalMethod);
                }
                catch (FaultException<BMS.FaultContracts.VistAException> ce) { return ce.Detail.ErrorMessage; }
                return string.Empty;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private DataContracts.VistASite GetVistaSite(VI.VistASite site, DataRetrievalMethod retrievalMethod)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DataContracts.VistASite vistaSite = new DataContracts.VistASite();
                vistaSite.VistaName = site.Name;
                vistaSite.TimeZoneId = site.TimeZone.Id;
                vistaSite.Id = site.Id;                
                vistaSite.Number = site.Number;
                vistaSite.MdwsEndpointConfigKey = site.MdwsEndpointConfigKey;
                if (retrievalMethod == DataRetrievalMethod.ODBC)
                {
                    vistaSite.AccessCode = site.OdbcUser;
                    vistaSite.VerifyCode = site.OdbcPassword;
                    vistaSite.ConnectionString = site.OdbcConnectionString;
                }
                return vistaSite;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void RunOnDemand(DataContracts.VistASite site, Utils.VistaDataType types, DateTime? startDate, DateTime? endDate, DataRetrievalMethod retrievalMethod)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BMSFactory.VistaQueryClient.RunOnDemand(site, types, startDate, endDate, retrievalMethod);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void TestConnection(DataContracts.VistASite site, DataRetrievalMethod retrievalMethod)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BMSFactory.VistaQueryClient.TestConnection(site, retrievalMethod);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<JobLogInfo> FilterLogData(IList<string> vistaIds, IList<BMS.Utils.DataRetrievalMethod> retrievalMethods, IList<VI.Admin.VistaDataType> dataTypes, DateTime startDate, DateTime? endDate, IList<BMS.Utils.JobStatus> status, PagingContext pagingContext, bool is_view_only_last_information)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return BMSFactory.BedManagerQueryClient.FilterLogData(vistaIds, retrievalMethods, dataTypes.Select<VI.Admin.VistaDataType, Utils.VistaDataType>(vdt => (Utils.VistaDataType)vdt).ToList(), startDate, endDate, status, pagingContext, is_view_only_last_information)
                    .Select<DC.JobLogInfo, JobLogInfo>(dcJLI => dcJLI.ToFacadeContract()).ToList();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public DateTime? FilterBPLastRun(string vistaId, IList<DataRetrievalMethod> retrievalMethod, IList<VI.Admin.VistaDataType> dataTypes, IList<JobStatus> status)
        {
            return BMSFactory.BedManagerQueryClient.FilterBPLastRun(vistaId, retrievalMethod, dataTypes.Select<VI.Admin.VistaDataType, Utils.VistaDataType>(vdt => (Utils.VistaDataType)vdt).ToList(), status);
        }
    }
}
