﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.Utils;

namespace BMS.Facade.Service
{
    /// <summary>
    /// Interface used to manipulate admission, discharge and transfer operations.
    /// </summary>
    public interface IADTOperations
    {
        /// <summary>
        /// Gets the transfer by id.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <returns></returns>
        Transfer GetTransferById(II id, User user);


        /// <summary>
        /// Gets the waiting list.
        /// </summary>
        /// <param name="facilityUid">The facility uid.</param>
        /// <param name="filterAdmissionCreationTime">The filter admission creation time.</param>
        /// <param name="isOnlyCurrentWaitingAdmission">if set to true get all the admission where remove date is null esle get all admission where admission creation date is GTE the filter admission date.</param>        
        /// <param name="facilityId">The facility id.</param>
        /// <returns></returns>
        IList<AdmissionInfo> GetWaitingList(Guid facilityUid, DateTime filterAdmissionCreationTime, bool isOnlyCurrentWaitingAdmission, bool isOnlyInHouseWaitingAdmission, II facilityId);

        /// <summary>
        /// Gets the patients in community hospitals.
        /// </summary>
        /// <param name="facility">The facility.</param>
        /// <param name="facilityVISN">The facility VISN.</param>
        /// <returns></returns>
        IList<TransferInfo> GetPatientsInCommunityHospitals(Facility facility, Visn facilityVISN);

        /// <summary>
        /// Gets the waiting list item.
        /// </summary>
        /// <param name="id">The waiting list item id.</param>
        /// <returns></returns>
        WaitingListItem GetWaitingListItem(II id, User user);

        /// <summary>
        /// Gets the waiting list item.
        /// </summary>
        /// <param name="waitingListItemId">The waiting list item id.</param>
        /// <param name="patientUid">The patient Uid.</param>
        /// <returns></returns>
        WaitingListItem GetWaitingListItem(II waitingListItemId, string patientUid);

        /// <summary>
        /// Transfers the request.
        /// </summary>
        /// <param name="transfer">The transfer.</param>
        /// <returns></returns>
        IList<ValidationAlert> TransferRequest(Transfer transfer);


        /// <summary>
        /// Gets the patients in community hospitals standard view.
        /// </summary>
        /// <param name="isDisplayOnlyNationalPatients">Display only national patients.</param>
        /// <param name="regionCode">The region code.</param>
        /// <param name="VISNCode">The VISN code.</param>
        /// <param name="pagingContext">The paging context.</param>
        /// <param name="specialty">The specialty.</param>
        /// <param name="isCurrentWaitingList">if set to true return all the patients where transfer event is null else filter by event date.</param>
        /// <param name="transferDateTime">The transfer date time.</param>
        /// <returns></returns>
        IList<TransferInfo> GetPatientsInCommunityHospitalsStandardView(bool isDisplayOnlyNationalPatients, string regionCode, string VISNCode, CD specialty, bool isCurrentWaitingList, DateTime transferDateTime);

        /// <summary>
        /// Gets the patients in community hospitals date view.
        /// </summary>
        /// <param name="isDisplayOnlyNationalPatients">Display only national patients.</param>
        /// <param name="regionCode">The region code.</param>
        /// <param name="VISNCode">The VISN code.</param>
        /// <param name="pagingContext">The paging context.</param>
        /// <param name="specialty">The specialty.</param>
        /// <param name="patientWaitingTime">The patient waiting time.</param>
        /// <param name="isCurrentWaitingList">if set to true  return all the patients where transfer event is null else filter by event date.</param>
        /// <param name="transferDateTime">The transfer date time.</param>
        /// <returns></returns>
        IList<DateView> GetPatientsInCommunityHospitalsDateView(bool isDisplayOnlyNationalPatients, string regionCode, string VISNCode, CD specialty, bool isCurrentWaitingList, DateTime transferDateTime);

        /// <summary>
        /// Modifies the waiting list item.
        /// </summary>
        /// <param name="waitingListItem">The waiting list item.</param>
        /// <param name="facility">The facility.</param>
        void ModifyWaitingListItem(WaitingListItem waitingListItem, Facility facility);

        /// <summary>
        /// Gets the last creation date for the specified act type.
        /// </summary>
        /// <param name="patientSSN">The patient's SSN.</param>
        /// <param name="actType">Type of the act.</param>
        /// <param name="vistaSiteNumber">The vista site number.</param>
        /// <returns></returns>
        Act GetLastAct(string patientSSN, ActType actType, string vistaSiteNumber);

        /// <summary>
        /// Gets the patient waiting count.
        /// </summary>
        /// <param name="facilityId">The facility id.</param>
        /// <param name="vistaSiteId">The vista site id.</param>
        /// <param name="vistaDivisionCode">The vista division code.</param>
        /// <param name="timeZoneOffset">The time zone offset.</param>
        /// <returns></returns>
        PatientWaitingCount GetPatientWaitingCount(II facilityId, II vistaSiteId, string vistaDivisionCode, int timeZoneOffset);

        /// <summary>
        /// Gets the waiting list report.
        /// </summary>
        /// <param name="facilityId">The facility id.</param>
        /// <param name="filterBy">The filter by.</param>
        /// <param name="filterPatientName">Name of the filter patient.</param>
        /// <param name="filterGender">The filter gender.</param>
        /// <returns></returns>
        List<WaitingListReport> GetWaitingListReport(II facilityId, string filterBy, string filterPatientName, string filterGender);

        /// <summary>
        /// Get all patients must be evacuated.
        /// </summary>
        /// <param name="facilityId">The facility id.</param>
        /// <param name="wardList">The ward list.</param>
        /// <returns></returns>
        IList<EvacuationPatient> GetEvacuationPatients(II facilityId, string wardList);

        /// <summary>
        /// Gets the patient location.
        /// </summary>
        /// <param name="patientId">The patient id.</param>
        /// <returns></returns>
        PatientLocation GetPatientLocation(II patientId, II vistaSiteId);

        /// <summary>
        /// Gets the home page BMS data.
        /// </summary>
        /// <param name="vistaSiteId">The vista site id.</param>
        /// <param name="facilityId">The facility id.</param>
        /// <param name="wardIdList">The ward id list.</param>
        /// <param name="flags">The flags.</param>
        /// <param name="timeZoneMinutesOffset">The time zone minutes offset.</param>
        /// <param name="filterAdmissionCreationTime">The filter admission creation time.</param>
        /// <param name="isOnlyCurrentWaitingAdmission">if set to <c>true</c> [is only current waiting admission].</param>
        /// <param name="isOnlyInHouseWaitingAdmission">if set to <c>true</c> [is only in house waiting admission].</param>
        /// <param name="bedOccupancylist">The bed occupancylist.</param>
        /// <param name="newEventsCount">The new events count.</param>
        /// <param name="facilityWaitingList">The facility waiting list.</param>
        void GetHomePageBMSData(II vistaSiteId, II facilityId, string wardIdList, List<Module> flags, int timeZoneMinutesOffset, DateTime filterAdmissionCreationTime, bool isOnlyCurrentWaitingAdmission, bool isOnlyInHouseWaitingAdmission,
                                            IList<DataRetrievalMethod> retrievalMethods, IList<VistaIntegration.FacadeContracts.Admin.VistaDataType> dataTypes, IList<JobStatus> status,
                                            out List<BedOccupancyCount> bedOccupancylist, out int newEventsCount, out List<AdmissionInfo> facilityWaitingList, out DateTime? bpLastRunDate);
    }
}
