﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Ward class. Stores information about ward.
    /// </summary>
    [DataContract]
    public class Ward : Place
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the division.
        /// </summary>
        /// <value>
        /// The division.
        /// </value>
        [DataMember]
        [ConvertDateTime]
        public Division Division { get; set; }

        /// <summary>
        /// Gets or sets the division list.
        /// </summary>
        /// <value>
        /// The division list.
        /// </value>
        [DataMember]
        public List<Division> DivisionList { get; set; }

        /// <summary>
        /// Gets or sets the VISTA Specialty.
        /// </summary>
        /// <value>
        /// The Specialty.
        /// </value>
        [DataMember]        
        public CD Specialty { get; set; }

        /// <summary>
        /// Gets or sets the type group.
        /// </summary>
        /// <value>
        /// The type group.
        /// </value>
        [DataMember]
        public string TypeGroup { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is active; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsActive { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is currently OOS.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is currently OOS; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsCurrentlyOOS { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [DataMember]
        public VistaSite VistaSite { get; set; }

        #endregion
    }
}
