﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace BMS.Facade.Data
{

    /// <summary>
    /// The read and write operations that  user can have on facility.
    /// </summary>
    public class UserOperations
    {
        /// <summary>
        /// Gets or sets the name of the user.
        /// </summary>
        /// <value>
        /// The name of the user.
        /// </value>
        public string UserName { get; set; }
        /// <summary>
        /// Gets or sets the user id.
        /// </summary>
        /// <value>
        /// The user id.
        /// </value>
        public string UserId { get; set; }
        /// <summary>
        /// Gets or sters the role id.
        /// </summary>
        public string RoleId { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether user can write on facility.
        /// </summary>
        /// <value>
        ///   <c>true</c> if [BMS read]; otherwise, <c>false</c>.
        /// </value>
        public bool BmsRead { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether user can write on facility.
        /// </summary>
        /// <value>
        ///   <c>true</c> if [BMS write]; otherwise, <c>false</c>.
        /// </value>
        public bool BmsWrite { get; set; }
    }
}