﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Hospital location class; stores information about vista hospital locations.
    /// </summary>
    [DataContract]
    public class HospitalLocation : Place
    {
        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [DataMember]
        public VistaSite VistaSite { get; set; }

        /// <summary>
        /// Gets or sets the abbrevation.
        /// </summary>
        /// <value>
        /// The abbrevation.
        /// </value>
        [DataMember]
        public string Abbrevation { get; set; }

        /// <summary>
        /// Gets or sets the telephone.
        /// </summary>
        /// <value>
        /// The telephone.
        /// </value>
        [DataMember]
        public string Telephone { get; set; }

        /// <summary>
        /// Gets or sets the ward location id.
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>
        [DataMember]
        public string WardLocationId { get; set; }
    }
}
