﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using System.Xml;
using BMS.Utils;

namespace BMS.VistaIntegration.FacadeContracts.Admin
{
    [Serializable]
    public class JobCalendar
    {
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the name of the calendar (job schedule).
        /// </summary>
        /// <value>
        /// The name of the calendar.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the occurrence interval.
        /// </summary>
        /// <value>
        /// The occurrence interval.
        /// </value>
        public OccurrenceInterval Occurs { get; set; }
        /// <summary>
        /// Gets or sets the number of intervals after which the job is scheduled againg.
        /// </summary>
        /// <value>
        /// The number of occurrence intervals.
        /// </value>
        public int Recurs { get; set; }
        /// <summary>
        /// Gets or sets the day schedule of the job.
        /// </summary>
        /// <value>
        /// The day based schedule.
        /// </value>
        public List<RunOnDay> RunOnDays { get; set; }
        /// <summary>
        /// Gets or sets the time the job starts when the day comes.
        /// </summary>
        /// <value>
        /// The start time.
        /// </value>

        public string TimeZoneId { get; set; }

        [XmlIgnore]
        public TimeSpan StartTime { get; set; }

        [XmlElement(DataType = "duration")]
        public string StartTimeDuration
        {
            get
            {
                return XmlConvert.ToString(this.StartTime);
            }

            set
            {
                this.StartTime = XmlConvert.ToTimeSpan(value);
            }
        }

        /// <summary>
        /// Gets or sets the end time (if equal to the start time, the job only runs once a day).
        /// </summary>
        /// <value>
        /// The end time.
        /// </value>
        [XmlIgnore]
        public TimeSpan EndTime { get; set; }

        [XmlElement(DataType = "duration")]
        public string EndTimeDuration
        {
            get
            {
                return XmlConvert.ToString(this.EndTime);
            }

            set
            {
                this.EndTime = XmlConvert.ToTimeSpan(value);
            }
        }

        /// <summary>
        /// Gets or sets the interval after which the job is run again on the same day (0 for once a day).
        /// </summary>
        /// <value>
        /// The run interval.
        /// </value>
        public int RunInterval { get; set; }
        /// <summary>
        /// Gets or sets the run interval unit.
        /// </summary>
        /// <value>
        /// The run interval unit.
        /// </value>
        public RunInterval RunIntervalUnit { get; set; }
    }
}
