﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace VistATool.Models
{
    public class WorkflowViewModel
    {
        public List<Workflow> WorkflowList { get; set; }
        public List<PATIENT> Patients { get; set; }
        public List<HOSPITAL_LOCATION> Facilities { get; set; }
        public List<ORDER_STATUS> OrderStatus { get; set; }
        public List<NEW_PERSON> Persons { get; set; }
        public List<TYPE_OF_MOVEMENT> Movements { get; set; }
        public List<ROOM_BED> Beds { get; set; }
        public List<FAC_TREAT_SPECIALTY> Specialities { get; set; }
        public List<WARD_LOCATION> Wards { get; set; }
        public List<MEDICAL_CENTER_DIVISION> Divisions { get; set; }
        public List<ORDERABLE_ITEM> OrderableItems { get; set; }
        public CPRS_ORDERS CPRSOrder { get; set; }
        public ORDER_ACTIONS OrderAction { get; set; }

        public PATIENT_APPOINTMENT PatientAppointment { get; set; }
        public int SelectedHospitalLocationIen { get; set; }

        public PATIENT_MOVEMENT PatientMovement { get; set; }
        public PATIENT SelectedPatient { get; set; }
        public int SelectedPatientIen { get; set; }
        public string MessageIfUserWantsToCreateEventBeforeRequest { get; set; }
        public string MessageForOrderableItem { get; set; }
        public string IsColumnTransactionHidden { get; set; }

        public SCHEDULED_ADMISSION ScheduledAdmission { get; set; }
        public List<ScheduledAdmissionWorkflow> ScheduledWorkflowList { get; set; }
        public bool IsSurgeryScheduledAdmission { get; set; }

        public string FillBeds { get; set; }
        public string FillWards { get; set; }

        public int HospitalLocationId { get; set; }

        public bool IsEnabledOrder { get; set; }
        public bool IsEnabledEvent { get; set; }
        public bool IsEnableScheduledAdmission { get; set; }
        public bool IsEnabledPatientAppointment { get; set; }
        public string InternalUid { get; set; }
    }

    public class Workflow
    {
        public string PatientName { get; set; }
        public string PatientLocation { get; set; }
        public DateTime StartDateTime { get; set; }
        public string OrderStatus { get; set; }
        public string OrderText { get; set; }
        public DateTime SignedDateTime { get; set; }
        public string SignedBy { get; set; }
        public string Provider { get; set; }
        public DateTime RealeaseDateTime { get; set; }
        public DateTime? EventDateTime { get; set; }
        public string EventEnterdBy { get; set; }
        public string TypeOfMovementEvent { get; set; }
        public string LocationEvent { get; set; }
        public string BedEvent { get; set; }
        public string Transaction { get; set; }
    }

    public class ScheduledAdmissionWorkflow
    {
        public SCHEDULED_ADMISSION ScheduledAdmission { get; set; }
        public DateTime? EventDateTime { get; set; }
        public string EventEnterdBy { get; set; }
        public string TypeOfMovementEvent { get; set; }
        public string LocationEvent { get; set; }
        public string BedEvent { get; set; }
    }
}
