﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class WardLocationController : Controller
    {
        //
        // GET: /WardLocation/

        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<WARD_LOCATION> list = new List<WARD_LOCATION>();

                foreach (WARD_LOCATION wardLocation in db.WARD_LOCATION.ToList())
                {
                    wardLocation.HOSPITAL_LOCATION = db.HOSPITAL_LOCATION.Find(wardLocation.HOSPITAL_LOCATION_ID);
                    //wardLocation.SPECIALTY = db.SPECIALTies.Find(wardLocation.SPECIALTY_ID);
                    list.Add(wardLocation);
                }
                return View(list);
            }
        }

        public ActionResult Create()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["HL"] = db.HOSPITAL_LOCATION.ToList();
                ViewData["SPECIALTY"] = db.SPECIALTies.ToList();
                return View();
            }
        }

        [HttpPost]
        public ActionResult Create(WARD_LOCATION wardLocation)
        {
            try
            {
                if (wardLocation.HOSPITAL_LOCATION_ID != 0 && wardLocation.SPECIALTY_ID != 0)
                {
                    using (var db = new BMS_VISTA_DBEntities())
                    {
                        db.WARD_LOCATION.Add(wardLocation);
                        wardLocation.SPECIALTY_NAME = db.SPECIALTies.Find(wardLocation.SPECIALTY_ID).NAME;
                        db.SaveChanges();
                    }
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
            }

            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["HL"] = db.HOSPITAL_LOCATION.ToList();
                ViewData["SPECIALTY"] = db.SPECIALTies.ToList();
            }

            return View();
        }

        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["HL"] = db.HOSPITAL_LOCATION.ToList();
                ViewData["SPECIALTY"] = db.SPECIALTies.ToList();
               
                return View(db.WARD_LOCATION.Find(id));
            }
        }

        [HttpPost]
        public ActionResult Edit(int id, WARD_LOCATION ward)
        {
            try
            {
                if (ward.HOSPITAL_LOCATION_ID != 0 && ward.SPECIALTY_ID != 0)
                {
                    using (var db = new BMS_VISTA_DBEntities())
                    {
                        db.Entry(ward).State = System.Data.EntityState.Modified;
                        ward.SPECIALTY_NAME = db.SPECIALTies.Find(ward.SPECIALTY_ID).NAME;
                        db.SaveChanges();
                        return RedirectToAction("Index");
                    }
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
            }

            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["HL"] = db.HOSPITAL_LOCATION.ToList();
                ViewData["SPECIALTY"] = db.SPECIALTies.ToList();
            }

            return View();
        }

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion

    }
}
