﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class TreatingSpecialtyController : Controller
    {
        #region Get Methods

        // GET: /TreatingSpecialty/
        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<FAC_TREAT_SPECIALTY> list = new List<FAC_TREAT_SPECIALTY>();
                foreach (FAC_TREAT_SPECIALTY spec in db.FAC_TREAT_SPECIALTY.ToList())
                {
                    list.Add(spec);
                }
                return View(list);
            }
        }

        //Get: /TreatingSpecialty/Create
        public ActionResult Create()
        {
            return View();
        }

        // GET: /TreatingSpecialty/Edit/id
        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                return View(db.FAC_TREAT_SPECIALTY.Find(id));
            }

        }

        #endregion

        #region Post Methods

        // POST: /TreatingSpecialty/Create
        [HttpPost]
        public ActionResult Create(FAC_TREAT_SPECIALTY spec)
        {
            try
            {                
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.FAC_TREAT_SPECIALTY.Add(spec);
                    db.SaveChanges();
                }

                return RedirectToAction("Index");
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        [HttpPost]
        public ActionResult Edit(int id, FAC_TREAT_SPECIALTY spec)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.Entry(spec).State = System.Data.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        #endregion

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion

    }
}
