﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class MedicalCenterDivisionController : Controller
    {
        #region Get Methods

        // GET: /MedicalCenterDivision/
        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                return View(db.MEDICAL_CENTER_DIVISION.ToList());
            }
        }

        // GET: /MedicalCenterDivision/Create/
        public ActionResult Create()
        {
            return View();
        }

        // GET: /MedicalCenterDivision/Edit/id
        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                return View(db.MEDICAL_CENTER_DIVISION.Find(id));
            }

        }

        #endregion

        #region Post Methods

        // POST: /MedicalCenterDivision/Create
        [HttpPost]
        public ActionResult Create(MEDICAL_CENTER_DIVISION medicalCenterDivision)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.MEDICAL_CENTER_DIVISION.Add(medicalCenterDivision);
                    db.SaveChanges();
                }
                return RedirectToAction("Index");
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        // POST: /MedicalCenterDivision/Edit/id

        [HttpPost]
        public ActionResult Edit(int id, MEDICAL_CENTER_DIVISION medicalCenterDivision)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.Entry(medicalCenterDivision).State = System.Data.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        #endregion

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion

    }
}
