﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;
using VistATool.Utils;

namespace VistATool.Controllers
{
    public class AdmissionWorkflowController : Controller
    {
        // GET: /AdmissionWorkflow/

        public ActionResult Index()
        {
            WorkflowViewModel viewModel = new WorkflowViewModel();
            FillWorkflowList(viewModel);
            return View(viewModel);
        }

        public ActionResult Create()
        {
            WorkflowViewModel viewModel = new WorkflowViewModel();
            FillModel(viewModel);
            viewModel.InternalUid = Guid.NewGuid().ToString();
            viewModel.IsEnabledOrder = true;
            viewModel.IsEnabledEvent = false;
            return View(viewModel);
        }

        [HttpPost]
        public ActionResult Create(WorkflowViewModel viewModel, string btnSaveOrder, string btnSavePatientMovement)
        {
            bool IsSaved = false;

            if (viewModel.FillBeds != null || viewModel.FillWards != null)
            {
                FillModel(viewModel);
                return View(viewModel);
            }
            try
            {
                if (viewModel.SelectedPatientIen == 0)
                    ModelState.AddModelError("SelectedPatientIen", "The PATIENT NAME field is required.");
                else
                    using (var db = new BMS_VISTA_DBEntities())
                    {
                        if (!string.IsNullOrEmpty(btnSaveOrder))
                        {
                            viewModel.CPRSOrder.OBJECT_OF_ORDER = db.PATIENTs.Find(viewModel.SelectedPatientIen).NAME;
                            viewModel.CPRSOrder.INTERNAL_UID = Guid.Parse(viewModel.InternalUid);
                            if (viewModel.CPRSOrder.IEN == 0)
                            {
                                if (viewModel.CPRSOrder.ORDERABLE_ITEM_ID == null)
                                {
                                    FillModel(viewModel);
                                    return View(viewModel);
                                }
                                ORDERABLE_ITEM orderableItem = db.ORDERABLE_ITEM.Where(a => a.IEN == viewModel.CPRSOrder.ORDERABLE_ITEM_ID.Value).FirstOrDefault();
                                viewModel.CPRSOrder.ORDERABLE_ITEM1.Add(orderableItem);
                                orderableItem.CPRS_ORDERS.Add(viewModel.CPRSOrder);
                                viewModel.OrderAction.CPRS_ORDERS = viewModel.CPRSOrder;
                                viewModel.OrderAction.DATE_TIME_ORDERED = DateTime.Now;

                                double value = 0;
                                if (viewModel.OrderAction.DATE_TIME_SIGNED != null && double.TryParse(viewModel.OrderAction.HourSelected, out value))
                                    viewModel.OrderAction.DATE_TIME_SIGNED = viewModel.OrderAction.DATE_TIME_SIGNED.Value.AddHours(value);

                                if (viewModel.OrderAction.DATE_TIME_SIGNED != null && double.TryParse(viewModel.OrderAction.MinuteSelected, out value))
                                    viewModel.OrderAction.DATE_TIME_SIGNED = viewModel.OrderAction.DATE_TIME_SIGNED.Value.AddMinutes(value);

                                if (viewModel.CPRSOrder.START_DATE != null && double.TryParse(viewModel.CPRSOrder.START_DATE_HOUR, out value))
                                    viewModel.CPRSOrder.START_DATE = viewModel.CPRSOrder.START_DATE.Value.AddHours(value);

                                if (viewModel.CPRSOrder.START_DATE != null && double.TryParse(viewModel.CPRSOrder.START_DATE_MINUTE, out value))
                                    viewModel.CPRSOrder.START_DATE = viewModel.CPRSOrder.START_DATE.Value.AddMinutes(value);

                                if (viewModel.OrderAction.RELEASE_DATE_TIME != null && double.TryParse(viewModel.OrderAction.RELEASE_HOUR, out value))
                                    viewModel.OrderAction.RELEASE_DATE_TIME = viewModel.OrderAction.RELEASE_DATE_TIME.Value.AddHours(value);

                                if (viewModel.OrderAction.RELEASE_DATE_TIME != null && double.TryParse(viewModel.OrderAction.RELEASE_MINUTE, out value))
                                    viewModel.OrderAction.RELEASE_DATE_TIME = viewModel.OrderAction.RELEASE_DATE_TIME.Value.AddMinutes(value);

                                db.ORDER_ACTIONS.Add(viewModel.OrderAction);
                            }
                            else
                            {
                                db.Entry(viewModel.CPRSOrder).State = System.Data.EntityState.Modified;
                                db.Entry(viewModel.OrderAction).State = System.Data.EntityState.Modified;
                            }
                        }
                        if (!string.IsNullOrEmpty(btnSavePatientMovement))
                        {
                            if (viewModel.CPRSOrder.IEN == 0)
                            {
                                ModelState.AddModelError("MessageIfUserWantsToCreateEventBeforeRequest", "Create Order and then Event");
                                FillModel(viewModel);
                                return View(viewModel);
                            }
                            else
                            {
                                if (viewModel.PatientMovement.ROOM_BED_ID == 0)
                                {
                                    ModelState.AddModelError("PatientMovement.ROOM_BED_ID", "The BED field is required.");
                                    FillModel(viewModel);

                                    return View(viewModel);
                                }
                                if (viewModel.PatientMovement.WARD_LOCATION_ID == 0)
                                {
                                    ModelState.AddModelError("PatientMovement.WARD_LOCATION_ID", "The WARD LOCATION field is required.");
                                    FillModel(viewModel);
                                    return View(viewModel);
                                }

                                if (viewModel.PatientMovement.TYPE_OF_MOVEMENT_ID == 0)
                                {
                                    ModelState.AddModelError("PatientMovement.TYPE_OF_MOVEMENT_ID", "The TYPE OF MOVEMENT field is required.");
                                    FillModel(viewModel);
                                    return View(viewModel);
                                }
                                viewModel.PatientMovement.PATIENT_ID = viewModel.SelectedPatientIen;
                                viewModel.PatientMovement.ENTERED_ON_DATETIME = DateTime.Now;
                                viewModel.PatientMovement.TRANSACTION_ = "1";
                                viewModel.PatientMovement.INTERNAL_UID = Guid.Parse(viewModel.InternalUid);
                                if (viewModel.PatientMovement.IEN == 0)
                                    db.Entry(viewModel.PatientMovement).State = System.Data.EntityState.Added;
                                else
                                    db.Entry(viewModel.PatientMovement).State = System.Data.EntityState.Modified;

                                double value = 0;
                                if (viewModel.PatientMovement.DATETIME != null && double.TryParse(viewModel.PatientMovement.DATETIME_HOUR, out value))
                                    viewModel.PatientMovement.DATETIME = viewModel.PatientMovement.DATETIME.Value.AddHours(value);

                                if (viewModel.PatientMovement.DATETIME != null && double.TryParse(viewModel.PatientMovement.DATETIME_MINUTE, out value))
                                    viewModel.PatientMovement.DATETIME = viewModel.PatientMovement.DATETIME.Value.AddMinutes(value);
                            }
                        }
                        db.SaveChanges();
                        IsSaved = true;
                        ModelState.Clear();
                    }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                IsSaved = false;
            }



            if (!string.IsNullOrEmpty(btnSaveOrder))
            {
                if (!IsSaved)
                {
                    viewModel.IsEnabledOrder = true;
                    viewModel.IsEnabledEvent = false;
                }
                else
                {
                    viewModel.IsEnabledOrder = false;
                    viewModel.IsEnabledEvent = true;
                }
            }

            if (!string.IsNullOrEmpty(btnSavePatientMovement))
            {
                if (!IsSaved)
                {
                    viewModel.IsEnabledOrder = false;
                    viewModel.IsEnabledEvent = true;
                }
                else
                {
                    viewModel.IsEnabledOrder = false;
                    viewModel.IsEnabledEvent = false;
                }
            }
            FillModel(viewModel);
            return View(viewModel);
        }

        private void FillWorkflowList(WorkflowViewModel viewModel)
        {
            viewModel.IsColumnTransactionHidden = "none";
            using (var db = new BMS_VISTA_DBEntities())
            {
                if (viewModel.WorkflowList == null)
                    viewModel.WorkflowList = new List<Workflow>();

                IEnumerable<CPRS_ORDERS> list = db.CPRS_ORDERS.OrderBy(a => a.OBJECT_OF_ORDER).ToList().Where(IsAdmission);

                foreach (CPRS_ORDERS order in list)
                {
                    Workflow item = new Workflow();
                    item.PatientName = order.OBJECT_OF_ORDER;
                    item.StartDateTime = order.START_DATE.Value;
                    if (order.HOSPITAL_LOCATION != null)
                        item.PatientLocation = order.HOSPITAL_LOCATION.NAME;

                    if (order.ORDER_STATUS != null)
                        item.OrderStatus = order.ORDER_STATUS.Name;
                    if (order.ORDER_ACTIONS != null)
                    {
                        item.OrderText = order.ORDER_ACTIONS.ORDER_TEXT;
                        item.SignedDateTime = order.ORDER_ACTIONS.DATE_TIME_SIGNED.Value;
                        item.RealeaseDateTime = order.ORDER_ACTIONS.RELEASE_DATE_TIME.Value;
                        if (order.ORDER_ACTIONS.NEW_PERSON != null)
                            item.SignedBy = order.ORDER_ACTIONS.NEW_PERSON.NAME;
                        if (order.ORDER_ACTIONS.NEW_PERSON1 != null)
                            item.Provider = order.ORDER_ACTIONS.NEW_PERSON1.NAME;

                        PATIENT patient = db.PATIENTs.Where(a => a.NAME == order.OBJECT_OF_ORDER).FirstOrDefault();
                        List<PATIENT_MOVEMENT> movements = new List<PATIENT_MOVEMENT>();
                        if (patient != null)
                        {
                            movements = patient.PATIENT_MOVEMENT.Where(a => a.TRANSACTION_ == "1" && a.INTERNAL_UID == order.INTERNAL_UID).ToList();
                            PATIENT_MOVEMENT patMovement = movements.FirstOrDefault();
                            if (patMovement != null)
                            {
                                item.TypeOfMovementEvent = patMovement.TYPE_OF_MOVEMENT.NAME;
                                item.BedEvent = patMovement.ROOM_BED.NAME;
                                item.EventDateTime = patMovement.DATETIME.Value;
                                item.EventEnterdBy = patMovement.NEW_PERSON.NAME;
                                item.LocationEvent = patMovement.WARD_LOCATION.NAME;
                            }
                        }
                    }

                    viewModel.WorkflowList.Add(item);
                }
            }

        }

        private static bool IsAdmission(CPRS_ORDERS value)
        {
            return IsAdmission(value.ORDERABLE_ITEM);
        }

        private static bool IsAdmission(ORDERABLE_ITEM value)
        {
            return value.NAME.Contains(Constants.Admission, StringComparison.OrdinalIgnoreCase);
        }

        private void FillModel(WorkflowViewModel viewModel)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                viewModel.OrderableItems = db.ORDERABLE_ITEM.OrderBy(a => a.NAME).ToList().Where(IsAdmission).ToList();
                viewModel.Patients = db.PATIENTs.OrderByDescending(a => a.IEN).ToList();
                viewModel.Facilities = db.HOSPITAL_LOCATION.OrderBy(a => a.NAME).ToList();
                viewModel.OrderStatus = db.ORDER_STATUS.ToList();
                viewModel.Persons = db.NEW_PERSON.OrderBy(a => a.NAME).ToList();
                viewModel.Movements = db.TYPE_OF_MOVEMENT.OrderBy(a => a.NAME).ToList();



                if (viewModel.SelectedPatientIen != 0)
                    viewModel.SelectedPatient = db.PATIENTs.Find(viewModel.SelectedPatientIen);

                if (viewModel.CPRSOrder == null)
                {
                    viewModel.CPRSOrder = new CPRS_ORDERS();
                    viewModel.CPRSOrder.START_DATE = DateTime.Now;
                    viewModel.CPRSOrder.START_DATE_HOUR = DateTime.Now.Hour.ToString();
                    viewModel.CPRSOrder.START_DATE_MINUTE = DateTime.Now.Minute.ToString();

                }

                if (viewModel.OrderAction == null)
                {
                    viewModel.OrderAction = new ORDER_ACTIONS();
                    viewModel.OrderAction.RELEASE_DATE_TIME = DateTime.Now;
                    viewModel.OrderAction.RELEASE_HOUR = DateTime.Now.Hour.ToString();
                    viewModel.OrderAction.RELEASE_MINUTE = DateTime.Now.Minute.ToString();

                    viewModel.OrderAction.DATE_TIME_SIGNED = DateTime.Now;
                    viewModel.OrderAction.HourSelected = DateTime.Now.Hour.ToString();
                    viewModel.OrderAction.MinuteSelected = DateTime.Now.Minute.ToString();
                }

                if (viewModel.PatientMovement == null)
                {
                    viewModel.PatientMovement = new PATIENT_MOVEMENT();
                    viewModel.PatientMovement.DATETIME = DateTime.Now;
                    viewModel.PatientMovement.DATETIME_HOUR = DateTime.Now.Hour.ToString();
                    viewModel.PatientMovement.DATETIME_MINUTE = DateTime.Now.Minute.ToString();
                }

                viewModel.Wards = db.WARD_LOCATION.Where(a => a.HOSPITAL_LOCATION_ID == viewModel.CPRSOrder.PATIENT_LOCATION_ID).OrderBy(a => a.NAME).ToList();
                List<RMDB_WARDS_WITH_CAN_ASSIGN> wards = db.RMDB_WARDS_WITH_CAN_ASSIGN.Where(a => a.WARDS_WHICH_CAN_ASSIGN_ID == viewModel.PatientMovement.WARD_LOCATION_ID).ToList();
                viewModel.Beds = new List<ROOM_BED>();
                foreach (RMDB_WARDS_WITH_CAN_ASSIGN ward in wards)
                {
                    ROOM_BED roombed = db.ROOM_BED.Where(a => a.IEN == ward.ROOM_BED_ID).FirstOrDefault();
                    if (roombed != null)
                        viewModel.Beds.Add(roombed);
                }
                viewModel.Beds = viewModel.Beds.OrderBy(a => a.NAME).ToList();
            }
        }

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }
    }
}
