USE V03BYNBMSDB
declare @EIS_FACILITY_ID int, @FACILITY_CODE nvarchar(20)
set @FACILITY_CODE = 'BYN'
SELECT @EIS_FACILITY_ID = E.PK_ENTITY
FROM bms_eis.dbo.ENTITY AS E 
	INNER JOIN bms_eis.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN bms_eis.dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN bms_eis.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = F.FK_ENTITY AND R.CLASS_CODE = 'MBR'
	INNER JOIN bms_eis.dbo.EHL7_ORGANIZATION AS O_VISTA ON O_VISTA.PFK_ORGANIZATION = R.FK_SCOPER_ENTITY
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

CREATE TABLE #BEDS (PK INT, BED_NAME NVARCHAR(50), BED_UID UNIQUEIDENTIFIER, WARD_GROUP_NAME NVARCHAR(50))

INSERT INTO #BEDS(PK, BED_NAME, BED_UID, WARD_GROUP_NAME)
SELECT DISTINCT BED.PFK_PLACE, BED.NAME, E.IDENTIFIER, O.NAME
FROM bms_eis.[dbo].[EHL7_PLACE] AS BED
INNER JOIN bms_eis.[dbo].[ENTITY] AS E ON E.PK_ENTITY = BED.PFK_PLACE
INNER JOIN bms_eis.[dbo].[EHL7_ROLE] AS R_BED ON R_BED.FK_PLAYER_ENTITY = BED.PFK_PLACE AND R_BED.[CLASS_CODE] = 'MNT'
INNER JOIN bms_eis.[dbo].[EHL7_ORGANIZATION] AS O ON O.PFK_ORGANIZATION = R_BED.FK_SCOPER_ENTITY
WHERE BED.CODE_DISPLAY_NAME ='BED' AND R_BED.FK_SCOPER_ENTITY IN (SELECT O.[PFK_ORGANIZATION]
FROM bms_eis.[dbo].[EHL7_ORGANIZATION] AS O
INNER JOIN bms_eis.[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @EIS_FACILITY_ID)
		
CREATE TABLE #PATIENTS(PATIENT_UID UNIQUEIDENTIFIER, BED_UID UNIQUEIDENTIFIER, BED_NAME NVARCHAR(50))
CREATE TABLE #ACTIVE_ADMISSION(ADMISSION_ID INT NOT NULL, CREATED_DATE DATETIME NULL)
CREATE TABLE #ADMISSION_AND_TRANSFER(ADMISSION_ID INT NOT NULL, BED_UID UNIQUEIDENTIFIER, CREATED_DATE DATETIME NULL)
	
--GET ACTIVE ADMISSION
--If more patients were admitted in the same bed on the whiteboard is displayed last patient admitted
INSERT INTO #ADMISSION_AND_TRANSFER(ADMISSION_ID, BED_UID, CREATED_DATE)
SELECT ADM_EVN.ID, ADM_EVN.BED_UID, ADM_EVN.ADMISSION_DATE
FROM bms.[dbo].ADMISSION_EVN AS ADM_EVN
	INNER JOIN #BEDS AS B ON ADM_EVN.BED_UID = B.BED_UID
WHERE ADM_EVN.HAS_DISCHARGE = 0

INSERT INTO #ADMISSION_AND_TRANSFER(ADMISSION_ID, BED_UID, CREATED_DATE)
SELECT MOV_EVN.ADMISSION_ID, MOV_EVN.BED_UID, MOV_EVN.MOVEMENT_DATE
FROM bms.[dbo].MOVEMENT_EVN AS MOV_EVN
	INNER JOIN (SELECT MAX(CAST(LAST_MOV_EVN.IEN as BIGINT)) AS IEN, LAST_MOV_EVN.ADMISSION_ID
				FROM bms.[dbo].MOVEMENT_EVN LAST_MOV_EVN
				INNER JOIN #ADMISSION_AND_TRANSFER AS ADM_EVN ON ADM_EVN.ADMISSION_ID = LAST_MOV_EVN.ADMISSION_ID
				GROUP BY LAST_MOV_EVN.ADMISSION_ID) MAX_ME_EVENT 
				ON MAX_ME_EVENT.IEN = CAST(MOV_EVN.IEN AS BIGINT) AND MAX_ME_EVENT.ADMISSION_ID = MOV_EVN.ADMISSION_ID

INSERT INTO #ACTIVE_ADMISSION(ADMISSION_ID, CREATED_DATE)
SELECT DISTINCT ADMISSION_INFO.ADMISSION_ID, ADMISSION_INFO.CREATED_DATE
FROM #ADMISSION_AND_TRANSFER AS ADMISSION_INFO
INNER JOIN 
(   SELECT MAX(CREATED_DATE) AS CREATED_DATE, BED_UID
	FROM #ADMISSION_AND_TRANSFER
	GROUP BY BED_UID
) LAST_ADMISISON_INFO ON LAST_ADMISISON_INFO.CREATED_DATE = ADMISSION_INFO.CREATED_DATE AND LAST_ADMISISON_INFO.BED_UID = ADMISSION_INFO.BED_UID

DROP TABLE #ADMISSION_AND_TRANSFER

--SELECT ADMITTED PATIENTS WITH ASSOCIATED BED
INSERT INTO #PATIENTS(PATIENT_UID, BED_UID, BED_NAME)
SELECT DISTINCT AE.PATIENT_UID, AE.BED_UID, B.BED_NAME
FROM bms.[dbo].[ADMISSION_EVN] AS AE 	
	INNER JOIN #ACTIVE_ADMISSION AS AA ON AE.ID = AA.ADMISSION_ID
	INNER JOIN #BEDS AS B ON AE.BED_UID = B.BED_UID
WHERE AE.HAS_DISCHARGE = 0 AND AE.BED_UID IS NOT NULL
	
DROP TABLE #ACTIVE_ADMISSION

;WITH DUPLICATE_BEDS (PK, BED_NAME)
AS
(
SELECT MAX(PK), BED_NAME
FROM #BEDS
WHERE BED_NAME NOT IN (SELECT DISTINCT BED_NAME FROM #PATIENTS)
GROUP BY BED_NAME
)

DELETE BED FROM #BEDS AS BED
LEFT OUTER JOIN DUPLICATE_BEDS AS DEL ON DEL.PK = BED.PK
WHERE DEL.PK IS NULL AND BED.BED_NAME NOT IN (SELECT DISTINCT BED_NAME FROM #PATIENTS)

;WITH DUPLICATE_OCC_BEDS (PK)
AS
(
SELECT B.PK
FROM #BEDS AS B
INNER JOIN #PATIENTS AS P ON P.BED_NAME = B.BED_NAME AND P.BED_UID <> B.BED_UID
)

DELETE BED FROM #BEDS AS BED
INNER JOIN DUPLICATE_OCC_BEDS AS DEL ON DEL.PK = BED.PK


CREATE TABLE #LOCAL_DATABASE_BED_ICON (BED_UID UNIQUEIDENTIFIER, TOTAL_ICONS INT)
CREATE TABLE #BMS_DATABASE_BED_ICON (BED_UID UNIQUEIDENTIFIER, TOTAL_ICONS INT)
INSERT INTO #LOCAL_DATABASE_BED_ICON(BED_UID, TOTAL_ICONS)
select d.BED_UID,
	   case when iCON.BATHFLAG = 'YES' THEN 1 ELSE 0 end
	   +  case when iCON.NEGPRESFlag = 'YES' THEN 1 ELSE 0 end
	   +  case when iCON.WProgFlag = 'YES' THEN 1 ELSE 0 end
 from 
(
select MAX(recnum) as recnum, VistaBed, bed.BED_UID
FROM  [Bed_Control_Whiteboard_Log] AS ICON
INNER JOIN #BEDS AS BED ON BED.BED_NAME = ICON.VistaBed AND BED.WARD_GROUP_NAME = ICON.Ward
group by ICON.VistaBed,  bed.BED_UID )d 
inner join  [Bed_Control_Whiteboard_Log] AS ICON on icon.RecNum = d.recnum


INSERT INTO #BMS_DATABASE_BED_ICON(BED_UID, TOTAL_ICONS)
SELECT I.BED_UID, COUNT(*)
FROM BMS.dbo.ICON_ASSOCIATION AS I
INNER JOIN #BEDS AS BED ON BED.BED_UID = I.BED_UID
GROUP BY I.BED_UID

SELECT 'LOCAL DATABASE (cls. 3) BED ' + cast(SUM(TOTAL_ICONS) AS NVARCHAR(100))
FROM #LOCAL_DATABASE_BED_ICON

SELECT 'BMS DATABASE (cls. 1) BED ' + cast(COUNT(*) AS NVARCHAR(100))
FROM #BMS_DATABASE_BED_ICON

--patient

CREATE TABLE #LOCAL_DATABASE_PATIENT_ICON (PATIENT_UID UNIQUEIDENTIFIER, TOTAL_ICONS INT)
CREATE TABLE #BMS_DATABASE_PATIENT_ICON (PATIENT_UID UNIQUEIDENTIFIER, TOTAL_ICONS INT)
INSERT INTO #LOCAL_DATABASE_PATIENT_ICON(PATIENT_UID, TOTAL_ICONS)

select PATIENT.PATIENT_UID,
	   case when iCON.CLSOBSFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.CauFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.FltFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.FluFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.HCapFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.LEquipFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.ONEFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.ObsvFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.OptOutFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.Oxy2Flag= 'YES' THEN 1 ELSE 0 end
			+  case when iCON.RTFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.ResFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.SIFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.STRETCHERFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.SlpFlag = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.TELFLAG = 'YES' THEN 1 ELSE 0 end
			+  case when iCON.VENTFlag = 'YES' THEN 1 ELSE 0 end

 from 
(
select MAX(recnum) as recnum, VistaBed, BED.BED_UID as BED_UID
FROM  [Bed_Control_Whiteboard_Log] AS ICON
INNER JOIN #BEDS AS BED ON BED.BED_NAME = ICON.VistaBed AND BED.WARD_GROUP_NAME = ICON.Ward
INNER JOIN #PATIENTS AS PATIENT ON PATIENT.BED_UID = BED.BED_UID
group by ICON.VistaBed, BED.BED_UID )d 
inner join  [Bed_Control_Whiteboard_Log] AS ICON on icon.RecNum = d.recnum
INNER JOIN #PATIENTS AS PATIENT ON PATIENT.BED_UID = D.BED_UID

INSERT INTO #BMS_DATABASE_PATIENT_ICON(PATIENT_UID, TOTAL_ICONS)
SELECT I.PATIENT_UID, COUNT(*)
FROM BMS.dbo.ICON_ASSOCIATION AS I
INNER JOIN #PATIENTS AS PAT ON PAT.PATIENT_UID = I.PATIENT_UID
GROUP BY I.PATIENT_UID

SELECT 'LOCAL DATABASE (CLS. 3) PATIENT ' + cast(SUM(TOTAL_ICONS) AS NVARCHAR(100))
FROM #LOCAL_DATABASE_PATIENT_ICON

SELECT 'BMS DATABASE (CLS. 1) PATIENT ' + cast(SUM(TOTAL_ICONS) AS NVARCHAR(100))
FROM #BMS_DATABASE_PATIENT_ICON

DROP TABLE #BMS_DATABASE_PATIENT_ICON
DROP TABLE #LOCAL_DATABASE_PATIENT_ICON
DROP TABLE #BMS_DATABASE_BED_ICON
DROP TABLE #LOCAL_DATABASE_BED_ICON
drop table #BEDS
drop table #PATIENTS