USE NEW_V16NOLBMSDB
DECLARE @FACILITY_CODE NVARCHAR(10), @FACILITY_ID INT, @START_DATE DATETIME, @VISTA_UID UNIQUEIDENTIFIER, @VISTA_ID INT
SET @FACILITY_CODE = 'BYN'
SET @START_DATE = '20110210'
SELECT @FACILITY_ID = E.PK_ENTITY, @VISTA_UID = V.IDENTIFIER, @VISTA_ID = V.PK_ENTITY
FROM BMS_EIS.dbo.ENTITY AS E
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
	INNER JOIN BMS_EIS.dbo.ENTITY AS V ON V.PK_ENTITY = R.FK_SCOPER_ENTITY
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

CREATE TABLE #WARD(WARD_NAME NVARCHAR(250), WARD_UID UNIQUEIDENTIFIER)
CREATE TABLE #WARDGROUP (NAME NVARCHAR(250), ID UNIQUEIDENTIFIER, PK INT)
CREATE TABLE #BEDS (PK INT, BED_NAME NVARCHAR(250), BED_UID UNIQUEIDENTIFIER)

INSERT INTO #WARD(WARD_NAME, WARD_UID)
SELECT WARD.NAME, E.IDENTIFIER 
FROM BMS_EIS.dbo.EHL7_PLACE AS WARD 
INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.PK_ENTITY = WARD.PFK_PLACE
INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R_W_VISTA ON R_W_VISTA.FK_PLAYER_ENTITY = E.PK_ENTITY AND R_W_VISTA.CLASS_CODE = 'OWN'
WHERE WARD.CODE_CODE = 'WRD' AND R_W_VISTA.FK_SCOPER_ENTITY = @VISTA_ID

INSERT INTO #WARDGROUP(PK)
SELECT DISTINCT O.PFK_ORGANIZATION
FROM BMS_EIS.[dbo].[EHL7_ORGANIZATION] AS O
INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @FACILITY_ID

INSERT INTO #BEDS(PK, BED_NAME, BED_UID)
SELECT DISTINCT BED.PFK_PLACE, BED.NAME, E.IDENTIFIER
FROM BMS_EIS.[dbo].[EHL7_PLACE] AS BED
INNER JOIN BMS_EIS.[dbo].[ENTITY] AS E ON E.PK_ENTITY = BED.PFK_PLACE
INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R_BED ON R_BED.FK_PLAYER_ENTITY = BED.PFK_PLACE AND R_BED.[CLASS_CODE] = 'MNT'
INNER JOIN #WARDGROUP AS WARD_GROUP ON WARD_GROUP.PK = R_BED.FK_SCOPER_ENTITY
WHERE BED.CODE_DISPLAY_NAME ='BED'

;WITH DUPLICATE_BEDS (PK, BED_NAME)
AS
(
SELECT MAX(PK), BED_NAME
FROM #BEDS
GROUP BY BED_NAME
)

DELETE BED FROM #BEDS AS BED
LEFT OUTER JOIN DUPLICATE_BEDS AS DEL ON DEL.PK = BED.PK
WHERE DEL.PK IS NULL	

DECLARE @COUNT_TOTAL_BC_FROM_LOCAL_DATABASE INT, @COUNT_MANUAL_REQUESTED_YES INT, @COUNT_MANUAL_REQUESTED_NO INT, @COUNT_TOTAL_EVENT_TYPE_NOT_FOUND INT, @COUNT_EVENT_TYPE_NOT_FOUND INT, 
		@COUNT_EVENT_TYPE_DIS_FOUND INT, @COUNT_EVENT_TYPE_TRA_FOUND INT, @COUNT_TOTAL_BC_FROM_BMS INT
	  
SELECT @COUNT_MANUAL_REQUESTED_YES = COUNT (*)
FROM BED_CONTROL_EMS AS BC
INNER JOIN #BEDS AS BED ON BED.BED_NAME = BC.RMBED
WHERE BC.DTREQUESTED >= @START_DATE AND ManRequest = 'YES'
		AND BC.WARD IS NOT NULL AND BC.WARD <> ''	AND BC.Ward IN (SELECT WARD_NAME FROM #WARD)

SELECT @COUNT_MANUAL_REQUESTED_NO = COUNT (*)
FROM BED_CONTROL_EMS AS BC
WHERE BC.DTREQUESTED >= @START_DATE AND (ManRequest = 'NO' OR ManRequest IS NULL)
		AND BC.WARD IS NOT NULL AND BC.WARD <> ''	AND BC.Ward IN (SELECT WARD_NAME FROM #WARD)

CREATE TABLE #DIS_FOUND(IEN BIGINT)
SELECT BC.RecNum
FROM  BED_CONTROL_EMS AS BC
INNER JOIN #WARD AS WARD ON WARD.WARD_NAME = BC.WARD
INNER JOIN BMS.dbo.DISCHARGE_EVN AS EVN ON EVN.WARD_UID = WARD.WARD_UID AND CAST(EVN.IEN AS BIGINT) = BC.RecNum
INNER JOIN #BEDS AS BED ON BED.BED_UID = EVN.BED_UID
WHERE BC.DTREQUESTED >= @START_DATE AND BC.WARD IS NOT NULL AND BC.WARD <> '' AND (ManRequest = 'NO' OR ManRequest IS NULL)
AND EVN.VISTA_SITE_UID = @VISTA_UID AND BC.RmBed IS NOT NULL AND BC.RmBed <> ''

SELECT @COUNT_EVENT_TYPE_TRA_FOUND = COUNT(*)
FROM  BED_CONTROL_EMS AS BC
INNER JOIN #WARD AS WARD ON WARD.WARD_NAME = BC.WARD
INNER JOIN BMS.dbo.MOVEMENT_EVN AS EVN ON EVN.OLD_WARD_UID = WARD.WARD_UID AND CAST(EVN.IEN AS BIGINT) = BC.RecNum
INNER JOIN #BEDS AS BED ON BED.BED_UID = EVN.OLD_BED_UID
LEFT OUTER JOIN #DIS_FOUND AS FOUND ON FOUND.IEN = BC.RecNum
WHERE FOUND.IEN IS NULL AND BC.DTREQUESTED >= @START_DATE AND BC.WARD IS NOT NULL AND BC.WARD <> '' AND (ManRequest = 'NO' OR ManRequest IS NULL)
AND EVN.VISTA_SITE_UID = @VISTA_UID AND BC.RmBed IS NOT NULL AND BC.RmBed <> ''

SELECT @COUNT_EVENT_TYPE_DIS_FOUND = COUNT(*)
FROM #DIS_FOUND

DROP TABLE #DIS_FOUND

SET @COUNT_TOTAL_BC_FROM_LOCAL_DATABASE = @COUNT_MANUAL_REQUESTED_NO + @COUNT_MANUAL_REQUESTED_YES

SET @COUNT_EVENT_TYPE_NOT_FOUND = @COUNT_MANUAL_REQUESTED_NO - (@COUNT_EVENT_TYPE_DIS_FOUND + @COUNT_EVENT_TYPE_TRA_FOUND)

SELECT @COUNT_TOTAL_BC_FROM_BMS = COUNT(*)
FROM BMS.dbo.BED_CLEAN WHERE VISTA_SITE_UID = @VISTA_UID

SET @COUNT_TOTAL_BC_FROM_LOCAL_DATABASE = @COUNT_TOTAL_BC_FROM_LOCAL_DATABASE - @COUNT_EVENT_TYPE_NOT_FOUND
IF @COUNT_TOTAL_BC_FROM_BMS = @COUNT_TOTAL_BC_FROM_LOCAL_DATABASE
	BEGIN
		SELECT 'BED CLEAN SUCCESSFULLY IMPORTED'
	END
ELSE
	BEGIN
		SELECT 'IN LOCAL DATABASE (CLS. 3) ARE: ' + CAST(@COUNT_TOTAL_BC_FROM_LOCAL_DATABASE AS NVARCHAR(MAX)) + ' BED CLEAN'
		SELECT 'IN BMS DATABASE (CLS. 1) ARE: ' + CAST(@COUNT_TOTAL_BC_FROM_BMS AS NVARCHAR(MAX)) + ' BED CLEAN'
		SELECT 'EVENT TYPE NOT FOUND: ' + CAST(@COUNT_EVENT_TYPE_NOT_FOUND AS NVARCHAR(MAX)) + ' BED CLEAN'	
		SELECT 'BED CLEAN UNSUCCESSFULLY IMPORTED'
	END 

DROP TABLE #WARD
DROP TABLE #WARDGROUP
DROP TABLE #BEDS



